#!/bin/sh

## Configuration constants
application_name="PragmaDev Developer"
application_option="-developer"


## Look for directory containing the application
exe_dir=`dirname $0`
cur_dir_elt=`basename $exe_dir`
app_dir=`dirname $exe_dir`
while [ "$cur_dir_elt" != "/" -a "`basename $cur_dir_elt .app`" = "`basename $cur_dir_elt`" ]
  do
    cur_dir_elt=`basename $app_dir`
    app_dir=`dirname $app_dir`
  done

## If not found, error
if [ "$cur_dir_elt" = "/" ]
then
  error_message="No application found in path $exe_dir."
## If found
else
  ## Check if there is a PragmaDevStudio.app in the directory for this application
  if [ -e "$app_dir/PragmaDevStudio.app" ]
  then
    ## Check that there is a shell script to run the application at the expected location
    if [ -e "$app_dir/PragmaDevStudio.app/Contents/MacOS/PragmaDevStudio.sh" ]
    then
      ## If shell script exists, run it with the proper option
      $app_dir/PragmaDevStudio.app/Contents/MacOS/PragmaDevStudio.sh $application_option $*
      exit $$
    ## If shell script does not exist, error
    else
      error_message="Application PragmaDev Studio in $app_dir is invalid."
    fi
  ## If PragmaDev Studio application does not exist, error
  else
    error_message="No application PragmaDev Studio found in $app_dir."
  fi
fi

## If we get there, there must be an error message: display it
error_message="$error_message  You may have to reinstall $application_name with the provided installation tool."
osascript <<.
display dialog "$error_message" buttons {"OK"}
.
exit 1
