#include <stdio.h>

#include "PragmaLib.h"
#include "RTDS_ExternalProcedures.h"


static FILE * PragmaDev_FilesArray[RTDS_MAX_FILES];

int PragmaDev_FileOpen(RTDS_String file_name, RTDS_String file_mode)
  {
  int file_id;
  for (file_id = 0; file_id < RTDS_MAX_FILES; ++file_id)
    {
    if (PragmaDev_FilesArray[file_id] == NULL)
      {
      PragmaDev_FilesArray[file_id] = fopen(file_name, file_mode);
      if (PragmaDev_FilesArray[file_id] != NULL)
        {
        break;
        }
      }
    }
  return (file_id < RTDS_MAX_FILES ? file_id: -1);
  }

RTDS_BOOLEAN PragmaDev_FileClose(int file_id)
  {
  if (PragmaDev_FilesArray[file_id] != NULL)
    {
    fclose(PragmaDev_FilesArray[file_id]);
    PragmaDev_FilesArray[file_id] = NULL;
    return TRUE;
    }
  return FALSE;
  }

char * PragmaDev_FileReadLine(int file_id, char * string_to_read)
  {
  if (PragmaDev_FilesArray[file_id] != NULL)
    {
    if (fgets(string_to_read, sizeof(RTDS_String), PragmaDev_FilesArray[file_id]) == NULL)
      {
      strcpy(string_to_read, "");
      }
    }
  return string_to_read;
  }

RTDS_BOOLEAN PragmaDev_FileWriteLine(RTDS_String string_to_write, int file_id)
  {
  if (PragmaDev_FilesArray[file_id] != NULL)
    {
    if (!(fputs(string_to_write, PragmaDev_FilesArray[file_id]) < 0))
      {
      return TRUE;
      }
    }
  return FALSE;
  }

int PragmaDev_RadarGraphCreate(RTDS_String graph_name, RTDS_String branch_labels)
  {
  return -1;  
  }

RTDS_BOOLEAN PragmaDev_RadarGraphAddLine(int graph_id, RTDS_String line_label, RTDS_String line_branch_values)
  {
  return TRUE;  
  }

PragmaDev_arg4sprintf * PragmaDev_b4sprintf(RTDS_BOOLEAN boolean_arg, PragmaDev_arg4sprintf * return_value)
  {
  PragmaDev_argtype4sprintf arg;
  arg.present = PragmaDev_argtype4sprintf_PragmaDev_b;
  arg.__value.PragmaDev_b = boolean_arg;
  return RTDS_PragmaDev_arg4sprintf_add(return_value, 0, &arg);
  }

PragmaDev_arg4sprintf * PragmaDev_i4sprintf(int integer_arg, PragmaDev_arg4sprintf * return_value)
  {
  PragmaDev_argtype4sprintf arg;
  arg.present = PragmaDev_argtype4sprintf_PragmaDev_i;
  arg.__value.PragmaDev_i = integer_arg;
  return RTDS_PragmaDev_arg4sprintf_add(return_value, 0, &arg);
  }

PragmaDev_arg4sprintf * PragmaDev_f4sprintf(float float_arg, PragmaDev_arg4sprintf * return_value)
  {
  PragmaDev_argtype4sprintf arg;
  arg.present = PragmaDev_argtype4sprintf_PragmaDev_f;
  arg.__value.PragmaDev_f = float_arg;
  return RTDS_PragmaDev_arg4sprintf_add(return_value, 0, &arg);
  }

PragmaDev_arg4sprintf * PragmaDev_s4sprintf(RTDS_String charstring_arg, PragmaDev_arg4sprintf * return_value)
  {
  PragmaDev_argtype4sprintf arg;
  arg.present = PragmaDev_argtype4sprintf_PragmaDev_s;
  RTDS_StringAssign(arg.__value.PragmaDev_s, charstring_arg);
  return RTDS_PragmaDev_arg4sprintf_add(return_value, 0, &arg);
  }

char * PragmaDev_sprintf(RTDS_String format, PragmaDev_arg4sprintf * args, char * return_value)
  {
  unsigned int i;
	PragmaDev_argtype4sprintf * RTDS_elements_args;
	RTDS_elements_args = (PragmaDev_argtype4sprintf *)args->elements;
  RTDS_String initial_format, tmp_format, tmp_result;
  PragmaDev_argtype4sprintf * arg;
  /* Insert initial dummy character for the first call to strtok */
  sprintf(initial_format, "_%s", format);
  /* Replace all %% with ascii SUB */
  char *pos = initial_format;
  while (pos != NULL)
    {
    pos = strstr(pos, "%%");
    if (pos == NULL) 
      break;
    strncpy(pos, "\x1A\x1A", 2);
    }
  /* Resolve format specifiers one-by-one */
  strcpy(tmp_format, strtok(initial_format, "%"));
  for (i=0; i<args->length; ++i)
    {
    strcat(tmp_format, "%");
    strcat(tmp_format, strtok(NULL, "%"));
    arg = &(RTDS_elements_args[i]);
    switch (arg->present)
      {
      case PragmaDev_argtype4sprintf_PragmaDev_b:
        sprintf(tmp_result, tmp_format, arg->__value.PragmaDev_b);
        break;
      case PragmaDev_argtype4sprintf_PragmaDev_i:
        sprintf(tmp_result, tmp_format, arg->__value.PragmaDev_i);
        break;
      case PragmaDev_argtype4sprintf_PragmaDev_f:
        sprintf(tmp_result, tmp_format, arg->__value.PragmaDev_f);
        break;
      case PragmaDev_argtype4sprintf_PragmaDev_s:
        sprintf(tmp_result, tmp_format, arg->__value.PragmaDev_s);
        break;
      }
    strcpy(tmp_format, tmp_result);
    }
  /* Restore all %% */
  pos = tmp_result;
  while (pos != NULL)
    {
    pos = strstr(pos, "\x1A\x1A");
    if (pos == NULL) 
      break;
    strncpy(pos, "%%", 2);
    }
  /* Remove initial dummy character, done */
  sprintf(return_value, &tmp_result[1]);
  return return_value;
  }
  
