import sys
import services.xml.cxml as cxml
from services.xml.string import normalize

old_sources = set()

def _get_source(element_name, element_text):
    old_sources.add(element_text)

element_mapping = {'source': (None, _get_source, None)}
cxml.parse("dictionary", element_mapping, sys.argv[1], cxml.PARSE_STRICT)

phrases = set(normalize(ph.replace('\\n', '\n').strip()) for ph in open(sys.argv[2]))
for phrase in phrases:
    if phrase and phrase not in old_sources:
        print '<translation><source>%s</source><target>######</target></translation>' % phrase
