/* PragmaDev RTDS VxWorks integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Include for RTDS types */
#include "RTDS_Common.h"

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
extern RTDS_GlobalProcessInfo * RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo;

#ifdef RTDS_SIMULATOR
    extern unsigned char * RTDS_globalMessageUniqueIdPool;
    extern RTDS_GlobalTraceInfo RTDS_globalTraceEntry;
    /* Global variable pointing to decoded parmaters */
    extern char * RTDS_globalPrintableParameters;
#endif

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */
extern void RTDS_Start( void );

extern long RTDS_GetTimerUniqueId ( RTDS_TimerState * );
extern void RTDS_WatchDogFunction ( RTDS_TimerState * );
extern void RTDS_StartTimer( RTDS_SdlInstanceId * instanceId, long, long, int, RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void RTDS_StopTimer( long, RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern unsigned long RTDS_GetSystemTime( void );

extern void RTDS_MsgQueueSend( long, long, unsigned char *, RTDS_SdlInstanceId *, RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * );
extern void RTDS_MsgReceive( RTDS_SdlInstanceId * instanceId, char * );
extern RTDS_RtosQueueId RTDS_MsgQueueCreate( void );
extern int RTDS_MsgQueueReceive( RTDS_RtosQueueId queueId, char * message, int size, int mode );

extern RTDS_SdlInstanceId * RTDS_GetProcessInstanceId( int processNumber );
extern void RTDS_ProcessCreate( char *, int processNumber, void *, int, RTDS_SdlInstanceId **, RTDS_SdlInstanceId *, short, RTDS_GlobalProcessInfo * );
extern RTDS_RtosTaskId RTDS_TaskCreate( char * processName, int priority, void ( * functionAddress )( void * ), void * parameter );
extern void RTDS_ProcessKill( RTDS_GlobalProcessInfo * );
extern RTDS_RtosTaskId RTDS_ProcessForget( RTDS_GlobalProcessInfo * RTDS_currentContext, short deleteQueue );

extern void RTDS_Sem_Delete( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreStatus RTDS_TakeSemaphoreId( RTDS_SemaphoreId, RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId RTDS_GetSemaphoreId( int semaphoreNumber );
extern RTDS_SemaphoreId RTDS_Sem_Info_Insert( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern void RTDS_SemaphoreIdGive( RTDS_SemaphoreId semaphoreId );
extern void RTDS_SemaphoreIdTake( RTDS_SemaphoreId semaphoreId, RTDS_SemaphoreTimeout timeout );
extern void RTDS_SemaphoreIdDelete( RTDS_SemaphoreId semaphoreId );
extern void RTDS_SemaphoreIdFlush( RTDS_SemaphoreId semaphoreId );
extern RTDS_SemaphoreId RTDS_MutexSemaphoreCreate( int options );
extern RTDS_SemaphoreId RTDS_BinarySemaphoreCreate( int options, SEM_B_STATE initialState );

extern void RTDS_TransitionCleanUp( RTDS_GlobalProcessInfo * RTDS_currentContext, int RTDS_sdlStatePrev );
extern void RTDS_TimerCleanUp( RTDS_GlobalProcessInfo * currentContext );

#ifdef RTDS_SIMULATOR
    extern unsigned long RTDS_GetMessageUniqueId ( void );
    extern void RTDS_ReleaseMessageUniqueId ( unsigned long );
    extern void RTDS_DummyTraceFunction ( void );
    extern void RTDS_messageDataToString( char ** buffer, long messageNumber, long dataLength, void * dataPointer, int level );
    extern char * RTDS_stringToMessageData( long messageNumber, long * dataLength, void ** dataPointer, char * dataString );
    extern void RTDS_SimulatorMsgQueueSend( long messageNumber, long dataLength, unsigned char * pData, RTDS_SdlInstanceId * receiver, RTDS_SdlInstanceId * sender, long MsgUniqueId );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
