/* PragmaDev RTDS uITRON 4 integration */
/* List of errors returned by RTDS 'kernel' */

/* RT OS ERROR*/
#define RTDS_E_ID                                                           0x1010  /* ID number (mbxIid is invalid or unusable, only cre_mbx)*/
#define RTDS_E_NOID                                                         0x1011  /* No ID number available (there is no mailbox ID assignable; only acre_mbx)*/
#define RTDS_E_NOMEM                                                        0x1012  /* Insufficient memory (message queue header area cannot be allocated)*/
#define RTDS_E_RSATR                                                        0x1013  /* Reseved attribute (mbxatr is invalid or unusable) */
#define RTDS_E_PAR                                                          0x1014  /* Parameter error (pk_cmbx, maxmpri, or mprihd is invalid)*/
#define RTDS_E_OBJ                                                          0x1015  /* Object State error */

/* TIMER */
#define RTDS_ERROR_NO_MORE_TIMER_UNIQUE_ID                                  0x0010
#define RTDS_ERROR_MSG_Q_SEND_IN_WATCHDOG                                   0x0011
#define RTDS_ERROR_WATCHDOG_CREATION                                        0x0012
#define RTDS_ERROR_WATCHDOG_START                                           0x0013
#define RTDS_ERROR_MSG_QUEUE_SEND                                           0x0014  /* Error sending message (when calling OS primitive)*/
#define RTDS_ERROR_MALLOC_TIMER_STATE_IN_START_TIMER                        0x0015
#define RTDS_ERROR_DEL_ALM                                                  0x0016

/* TASK */
#define RTDS_ERROR_TASK_TO_DELETE_NOT_FOUND                                 0x0020 /* The task to delete was not found in the globalProcessInfoList */
#define RTDS_ERROR_MSG_QUEUE_DELETE                                         0x0021
#define RTDS_ERROR_PROCESS_CREATE_MALLOC                                    0x0022
#define RTDS_ERROR_GET_PROCESS_QUEUE_ID                                     0x0023 /* process name not found */
#define RTDS_ERROR_GET_TID                                                  0x0024 /* Error when call get_tid in RTDS_GetCurrentThread */

/* SEMAPHORE */
#define RTDS_ERROR_SEM_INFO_INSERT_MALLOC                                   0x0030
#define RTDS_ERROR_SEM_INFO_INSERT                                          0x0031
#define RTDS_ERROR_GET_SEMAPHORE_ID                                         0x0032 /* semaphore name not found */
#define RTDS_ERROR_CREATE_MUTEX_NOT_APPLICABLE                              0x0033 /* The Nucleus UIT4 API do not implements mutex */
#define RTDS_ERROR_SEM_FLUSH                                                0x0034 /* Error when flushing synchronization semaphore */
#define RTDS_ERROR_SEM_DEL                                                  0x0035 /* Error when delete a semaphore */
#define RTDS_ERROR_SEM_SIG                                                  0x0036 /* Error when signal a semaphore */
#define RTDS_ERROR_SEM_WAI                                                  0x0037 /* Error when taking a semaphore */

/* MESSAGE*/
#define RTDS_ERROR_NO_MORE_MSG_UNIQUE_ID                                    0x0040 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_MSG_RECEIVE                                              0x0041 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_MSG_INPUT                                                0x0042

/* TIME */
#define RTDS_ERROR_GET_TIM                                                  0x0050 /* Error where call get_tim in RTDS_TickGet(void) */
#define RTDS_ERROR_SET_TIM                                                  0x0051 /* Error where call set_tim in RTDS_TickGet(long) */

/* MEMORY ALLOCATION */
#define RTDS_ERROR_MALLOC                                                   0x0070 /* malloc return a NULL pointer */
#define RTDS_ERROR_PGETMPL                                                  0x0071 /* Error where call get_mpl in RTDS_Malloc */
#define RTDS_ERROR_RELMPL                                                   0x0072 /* Error where call rel_mpl in RTDS_Free */
#define RTDS_ERROR_STARTUP_CONTEXT_MALLOC                                   0x0073
