#ifndef _RTDS_BASICTYPES_H_
#define _RTDS_BASICTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#define RTDS_MEMPOLL_SIZE                   40000                       /* Memory pool size in octet */
#define RTDS_MEMORY_POLL_CREATION           RTDS_MPoolCreate( RTDS_MEMPOLL_SIZE );

/* UITRON ERROR MESSAGE */
#define UITRON_OK                           E_OK
#define UITRON_ERROR                        -1
#define RTDS_SYS_NONE                       0                           /* Default option parameter */

/* RTDS ERROR MESSAGE */
#define RTDS_OK                             0
#define RTDS_ERROR                          -1

#define UITRON_SEMAPHORE_LOCKED             0                           /* Locked parameter for semaphore creation */
#define UITRON_SEMAPHORE_INTERPROCESS       1                           /* Creation parameter for using this sem. in various process */
#define UITRON_SEMAPHORE_MONOPROCESS        0                           /* Creation parameter for using this sem. only in the creating process */

#define RTDS_UITRON_SEM_TIMEOUT_FOREVER     -1
#define RTDS_SEMAPHORE_OPTION_PRIO          TA_TPRI                     /* Priority mode for creating semaphore */
#define RTDS_SEMAPHORE_OPTION_FIFO          TA_TFIFO                    /* Fifo mode for creating semaphore */
#define RTDS_BINARY_SEM_INITIAL_FULL        1                           /* Ressource disponibility for creating semaphore */
#define RTDS_BINARY_SEM_INITIAL_EMPTY       0                           /* Binary semaphore creation initial state: empty */
#define UITRON_SEMAPHORE_DEFAULT_MODE       RTDS_SEMAPHORE_OPTION_FIFO  /* Default mode for creating semaphore */

/* *****************************************************************
 * RTOS Specific
 *
 * When using NUCLEUS uItron :
 ***************************************************************** */
#define RTDS_MAX_TASK_UNIQUEID              TMAX_TSK_OBJ
#define RTDS_MAX_SEMAPHORE_ID               TMAX_SEM_OBJ
#define RTDS_MAX_MSGBOX_ID                  TMAX_MPF_OBJ
#define RTDS_MAX_TIMER_ID                   TMAX_ALM_OBJ

#define RTDS_INITIAL_NB_MSGBOX              ID_MPF1
#define RTDS_INITIAL_NB_SEMAPHORE           ID_SEM1
#define RTDS_INITIAL_NB_TASK                TASK_MAIN
#define RTDS_INITIAL_NB_TIMER               ID_ALM1

/* *****************************************************************
 * Used for task creation
 * In function :
 *       RTDS_STARTUP_PROCESS_CREATE
 ***************************************************************** */
#define RTDS_DEFAULT_PROCESS_PRIORITY       4                           /* Priority when creating a task */
#define RTDS_TASK_STACK_SIZE                500                         /* Stack size when creating a new task */
#define RTDS_MAX_TASK                       TMAX_TSK_OBJ                /* Define the max number of processes */

/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS

/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
    RTDS_ProcessPriority priority; T_CMBX * taskQueue; T_CTSK * taskStruct; 

/* *****************************************************************
 * SEMAPHORE TYPES
 * ----------------------------------------------------------------
 * Use of a UNION to detect set semaphore type according
 * the SDL-RT specification
 *
 ****************************************************************** */
enum RTDS_TypeName{ COUNTING, BINARY };

typedef struct rtds_SemId
    {
    ID semId;
    enum RTDS_TypeName semType;
    T_CSEM confStruct;
    }rtds_SemId;

typedef union RTDS_SemType
    {
    ID SemID;
    struct rtds_SemId RTDS_Info;
    }RTDS_SemType;

typedef RTDS_SemType * RTDS_SemId;

typedef void * FUNCPTR;

typedef struct T_MSG_PACKET
    {
    T_MSG header;
    struct RTDS_MessageHeader * msgHeader;
    }T_MSG_PACKET;

#define MSG_PACKET sizeof( T_MSG_PACKET )

/*
 * TYPE RTDS_PROCESS.ID:
 * ----------------------
 * Type for process identifier
 */
typedef ID RTDS_RtosTaskId;

/*
 * TYPE RTDS_PROCESS.PRIORITY.
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;

/*
 * TYPE RTDS_QUEUE.Id:
 * ----------------------
 * Type for a message queue identifier
 */
typedef ID RTDS_RtosQueueId;

/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 */
typedef RTDS_SemId RTDS_SemaphoreId;

/*
 * DEFINE FOR TIMER:
 * ------------------------------
 */
typedef ID RTDS_TimerId;

/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef int RTDS_SemaphoreStatus;

/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef long RTDS_SemaphoreTimeout;

/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */
typedef struct RTDS_TimerState
    {
    long timerNumber;                       /* Message number for the timer name */
    long timerUniqueId;                     /* Timer's unique identifier among all timers */
    unsigned long timeoutValue;             /* System tick counter value when it will go off */
    struct RTDS_SdlInstanceId * receiverId; /* The instance id of the receiver */
    int state;                              /* State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
    T_MSG_PACKET * timerMessage;            /* The timer message is already allocated to avoid a mem alloc in watchdog function */
    T_CALM * alarmControl;                  /* Kept in structure to free the allocated memory */
    RTDS_TimerId watchDogId;                /* Id of the watchDog to free alarm control block */
    struct RTDS_TimerState * next;          /* 0x18 Next timer in list */
    }RTDS_TimerState;

/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 * Don't invert fields !!! This would mess up the gopher script !!!
 */
typedef struct RTDS_GlobalSemaphoreInfo
    {
    RTDS_SemaphoreId semaphoreId;           /* The semaphore address */
    int semaphoreNumber;                    /* Semaphore number representing its name */
    struct RTDS_GlobalSemaphoreInfo * next; /* Next semaphoreInfo */
    }RTDS_GlobalSemaphoreInfo;

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_BASICTYPES_H_ */

