/* Copyright (C) 2003 PragmaDev */

/* Will only run with SDL-RT debugger */
#ifdef RTDS_SIMULATOR

/* These functions trace in a circular buffer to back trace the latest events */
#include "RTDS_OS.h"
#include "RTDS_MACRO.h"
#include "RTDS_BackTrace.h"

#ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM

RTDS_TraceList
	*RTDS_globalTraceBufferAddress=NULL,			/* Address of the beginning trace buffer */
	*RTDS_globalTraceNextBufferAddress=NULL,	/* Address of the next trace to come */
	*RTDS_globalTraceBufferStartAddress=NULL; /* Address of the latest trace available. Start from here when analyzing. */


/* **************************************************************** *
 *	RTDS_TraceInit
 * **************************************************************** *
 * Initialize the pointers to the RAM buffer to store the latest
 * SDL events
 * **************************************************************** *
 * Parameters:
 *	 none
 * Returns:
 *	 nothing
 * **************************************************************** */
void RTDS_TraceInit(void)
	{
	RTDS_globalTraceBufferAddress = (RTDS_TraceList *)RTDS_MALLOC((RTDS_BACK_TRACE_MAX_EVENT_NUM+1)*sizeof(RTDS_TraceList));
	if (RTDS_globalTraceBufferAddress == NULL)
		{
		RTDS_SYSTEM_ERROR(RTDS_ERROR_BACK_TRACE_NOT_ENOUGH_MEMORY);
		}
	RTDS_globalTraceNextBufferAddress = RTDS_globalTraceBufferAddress;
	RTDS_globalTraceBufferAddress->next = NULL;
	RTDS_globalTraceBufferStartAddress = RTDS_globalTraceBufferAddress;
	}


/* **************************************************************** *
 *	RTDS_TraceAdd
 * **************************************************************** *
 * Stores the current SDL event in the RAM buffer
 * **************************************************************** *
 * Parameters:
 *	 none
 * Returns:
 *	 nothing
 * **************************************************************** */
void RTDS_TraceAdd(void)
	{
	RTDS_TraceList	*currentTrace=NULL;
	long	i;

	/* Note RTDS_globalTraceNextBufferAddress already points to an available slot */
	currentTrace = RTDS_globalTraceNextBufferAddress;

	currentTrace->systemTime = RTDS_GetSystemTime();
	currentTrace->event = RTDS_globalTraceEntry.event;
	currentTrace->eventParameter1 = RTDS_globalTraceEntry.eventParameter1;
	currentTrace->eventParameter2 = RTDS_globalTraceEntry.eventParameter2;
	if (RTDS_globalTraceEntry.currentContext != NULL)
		currentTrace->activeTask = RTDS_globalTraceEntry.currentContext->mySdlInstanceId;
	else
		currentTrace->activeTask = (RTDS_SdlInstanceId *) NULL;
	/* Case of message sending, receiving, or saving */
	if (currentTrace->event == RTDS_messageSent || currentTrace->event == RTDS_messageReceived || currentTrace->event == RTDS_messageSaved )
		{
			currentTrace->eventSpecific.message.messageNumber = ((RTDS_MessageHeader *)(RTDS_globalTraceEntry.eventParameter1))->messageNumber;
			currentTrace->eventSpecific.message.timerUniqueId = ((RTDS_MessageHeader *)(RTDS_globalTraceEntry.eventParameter1))->timerUniqueId;
#ifdef RTDS_SIMULATOR
			currentTrace->eventSpecific.message.messageUniqueId = ((RTDS_MessageHeader *)(RTDS_globalTraceEntry.eventParameter1))->messageUniqueId;
#endif
			currentTrace->eventSpecific.message.sender = ((RTDS_MessageHeader *)(RTDS_globalTraceEntry.eventParameter1))->sender;
#if RTDS_BACK_TRACE_MESSAGE_DATA_SIZE != 0
			/* Look for parameters only if not a timer */
			if ( (currentTrace->eventSpecific.message.timerUniqueId == 0) && (RTDS_globalPrintableParameters!=NULL) )
				{
				currentTrace->eventSpecific.message.dataLength = ((RTDS_MessageHeader *)(RTDS_globalTraceEntry.eventParameter1))->dataLength;
				for (i=0; i<RTDS_BACK_TRACE_MESSAGE_DATA_SIZE /*&& i<currentTrace->eventSpecific.message.dataLength*/ ;i++)
					{
					currentTrace->eventSpecific.message.pData[i] = *((unsigned char *)(RTDS_globalPrintableParameters)+i);
					/*	currentTrace->eventSpecific.message.pData[i] = *((unsigned char *)(((RTDS_MessageHeader *)(RTDS_globalTraceEntry.eventParameter1))->pData)+i); */
					}
				/* Put the NULL character at the end */
				currentTrace->eventSpecific.message.pData[RTDS_BACK_TRACE_MESSAGE_DATA_SIZE-1] = 0x00;
				/* Reduce dataLength to what has been stored */
				currentTrace->eventSpecific.message.dataLength = i;
				}
			else
				/* In that case it is a timer */
				{
					currentTrace->eventSpecific.message.dataLength = 0;
				}
#else
			currentTrace->eventSpecific.message.dataLength = 0;
#endif
		}
	/* Case of timer started or cancelled */
	else if ( currentTrace->event == RTDS_timerStarted || currentTrace->event == RTDS_timerCancelled )
		{
			currentTrace->eventSpecific.timer.timerNumber = ((RTDS_TimerState *)(RTDS_globalTraceEntry.eventParameter1))->timerNumber;
			currentTrace->eventSpecific.timer.timerUniqueId = ((RTDS_TimerState *)(RTDS_globalTraceEntry.eventParameter1))->timerUniqueId;
			currentTrace->eventSpecific.timer.timerUniqueId = ((RTDS_TimerState *)(RTDS_globalTraceEntry.eventParameter1))->timeoutValue;
		}
	/* Case of task created */
	else if ( currentTrace->event == RTDS_processCreated || currentTrace->event == RTDS_processDied )
		{
			currentTrace->eventSpecific.pid = ((RTDS_GlobalProcessInfo *)(RTDS_globalTraceEntry.eventParameter1))->mySdlInstanceId;
		}


	/* Watch the diff between pointers... */
	if ( currentTrace - RTDS_globalTraceBufferAddress > RTDS_BACK_TRACE_MAX_EVENT_NUM-1 )
		{
			/* We have reached the end of the buffer */
			currentTrace->next = RTDS_globalTraceBufferAddress;
			RTDS_globalTraceBufferStartAddress++;
			RTDS_globalTraceNextBufferAddress = RTDS_globalTraceBufferAddress;
		}
	else
		currentTrace->next = ++RTDS_globalTraceNextBufferAddress;

	RTDS_globalTraceNextBufferAddress->next = NULL;

	/* Pushes the latest trace if needed */
	if (RTDS_globalTraceBufferStartAddress == RTDS_globalTraceNextBufferAddress)
		{
			if ( RTDS_globalTraceBufferStartAddress - RTDS_globalTraceBufferAddress > RTDS_BACK_TRACE_MAX_EVENT_NUM-1 )
				RTDS_globalTraceBufferStartAddress = RTDS_globalTraceBufferAddress;
			else
				RTDS_globalTraceBufferStartAddress++;
		}
	}


#endif /* RTDS_BACK_TRACE_MAX_EVENT_NUM */
#endif /* RTDS_SIMULATOR */

