/* *************************************************************** */
/* $(RTDS_HOME)/share/ccg/threadx/bricks/RTDS_Startup_end.c begins */
/* PragmaDev RTDS ThreadX integration                              */

RTDS_SIMULATOR_TRACE(RTDS_initDone, NULL, NULL, RTDS_currentContext);

}


/* **************************************************************** *
 *	tx_application_define
 * **************************************************************** *
 * ThreadX kernel user application entry point
 * **************************************************************** *
 * Parameters:
 *	 _tx_initialize_unused_memory
 *	 This VOID pointer contains the first memory
 *	 address available to the application after
 *	 ThreadX is initialized. The contents of this
 *	 variable is passed into the applications
 *	 tx_application_define function.
 * Returns:
 *	 nothing
 * **************************************************************** *
 * Context:
 *	 Called automatically by threadx kernel (hard coded)
 *	 When tx_application_define returns, control is
 *	 transferred to the thread scheduling loop. This marks
 *	 the end of initialization!
 * **************************************************************** */
void		tx_application_define(void *first_unused_memory)
{
	RTDS_Start(first_unused_memory);
}


/* **************************************************************** *
 *	main
 * **************************************************************** *
 * Starts threadx kernel
 * threadx kernel will call tx_application_define
 * **************************************************************** *
 * Parameters:
 *	 none
 * Returns:
 *	 nothing
 * **************************************************************** *
 * Context:
 *	 Called by the bootstrap
 * **************************************************************** */

int main()
{

	/* Enter the ThreadX kernel.	*/
	tx_kernel_enter();

	/* To call for clean exit of the system by the last task */
	/*
	tx_byte_pool_delete(&RTDS_globalBytePool);
	RTDS_CRITICAL_SECTION_POSTAMBLE;
	*/
}

/* $(RTDS_HOME)/share/ccg/threadx/bricks/RTDS_Startup_end.c ends */
/* ************************************************************* */

