/* ***************************************************************** */
/* $(RTDS_HOME)/share/ccg/threadx/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS ThreadX integration                                */

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo		*RTDS_globalProcessInfo=NULL;
RTDS_GlobalSemaphoreInfo	*RTDS_globalSemaphoreInfo=NULL;

TX_BYTE_POOL						RTDS_globalBytePool;

RTDS_COVERAGE_DECL;
RTDS_CRITICAL_SECTION_DECL;



/* **************************************************************** *
 *	RTDS_Start
 * **************************************************************** *
 * That is RTDS generated code entry point.
 * This task or function will create all the static processes and
 * semaphores and when everyone is ready will let them go.
 * **************************************************************** *
 * Parameters:
 *	 _tx_initialize_unused_memory
 *	 This VOID pointer contains the first memory
 *	 address available to the application after
 *	 ThreadX is initialized. The contents of this
 *	 variable is passed into the applications
 *	 tx_application_define function.
 * Returns:
 *	 nothing
 * **************************************************************** *
 * Context:
 *	 Called automatically by threadx kernel (hard coded)
 *	 When tx_application_define returns, control is
 *	 transferred to the thread scheduling loop. This marks
 *	 the end of initialization!
 * **************************************************************** */

void		RTDS_Start(void *first_unused_memory)
{

RTDS_GlobalProcessInfo *RTDS_currentContext;

/* Create a byte memory pool from which to allocate from.  */
tx_byte_pool_create(&RTDS_globalBytePool, "RTDS_globalBytePool", first_unused_memory, RTDS_THREADX_BYTE_POOL_SIZE);

RTDS_COVERAGE_INIT;

#ifdef RTDS_SIMULATOR
/* Set up the message unique id pool */
RTDS_globalMessageUniqueIdPool = (unsigned char *)RTDS_MALLOC(RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE);
	{
	int RTDS_i;
	unsigned char *index;

	index = RTDS_globalMessageUniqueIdPool;
	for(RTDS_i=0;RTDS_i<RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE;RTDS_i++)
		{
		*index=0x00;
		index++;
		}
	}
#endif

#if defined(RTDS_BACK_TRACE_MAX_EVENT_NUM) && defined(RTDS_SIMULATOR)
/* Initialize circular buffer to trace in RAM */
RTDS_TraceInit();
#endif


/* Set up the process context needed to create tasks */

RTDS_currentContext = (RTDS_GlobalProcessInfo *)RTDS_MALLOC(sizeof(RTDS_GlobalProcessInfo));
if ( RTDS_currentContext == NULL )
	RTDS_SYSTEM_ERROR(RTDS_ERROR_STARTUP_CONTEXT_MALLOC);

RTDS_currentContext->sdlProcessNumber = 0;
RTDS_currentContext->myRtosTaskId = ( RTDS_RtosTaskId )0;
RTDS_currentContext->sdlState = 0;
RTDS_currentContext->next = NULL;
RTDS_currentContext->parentSdlInstanceId = NULL;
RTDS_currentContext->offspringSdlInstanceId = NULL;
RTDS_currentContext->currentMessage = NULL;
RTDS_currentContext->timerList = NULL;
RTDS_currentContext->mySdlInstanceId = NULL;


RTDS_CRITICAL_SECTION_INIT;
/* $(RTDS_HOME)/share/ccg/threadx/bricks/RTDS_Startup_begin.c ends */
/* *************************************************************** */
