#ifndef _RTDS_SEMAPHORE_PROCESS_H_
#define _RTDS_SEMAPHORE_PROCESS_H_

#include "RTDS_Proc.h"


/*
** TYPE RTDS_WaitingProcessList:
** -----------------------------
** Chained list for instances waiting for a semaphore
*/

typedef struct _RTDS_WaitingProcessList
  {
  RTDS_SdlInstanceId              * sdlInstanceId;
  struct _RTDS_WaitingProcessList * next;
  } RTDS_WaitingProcessList;

/*
** PROCESS RTDS_SemaphoreProcess:
** ------------------------------
*/

class RTDS_SemaphoreProcess : public RTDS_Proc
  {
  public:
    // Constructor
    RTDS_SemaphoreProcess(RTDS_Scheduler * parentScheduler);
    
    // Checks if the semaphore is available
    virtual long isAvailable() = 0;
    
  protected:
    RTDS_WaitingProcessList * waiting_processes_head;
    RTDS_WaitingProcessList * waiting_processes_last;
    

    // Add an instance to list of waiting instances
    void _addWaitingInstance(RTDS_SdlInstanceId * instance_id);
    
    // Pops the first waiting instance from the list
    short _popFirstWaitingInstance(RTDS_SdlInstanceId ** returned_id);
    
    // Removes a given waiting instance from the list
    short _removeWaitingInstance(RTDS_SdlInstanceId * instance_id);
  };

#else

class RTDS_SemaphoreProcess;

#endif
