/* PragmaDev RTDS posix integration */

#ifndef _RTDS_MACRO_H_
#define _RTDS_MACRO_H_

/****************************************************************************************
 *                                                            RTDS_MACRO.c
 * ------------------------------------------------------------------------------------ *
 * Macro called by generated code.
 *
 * ************************************************************************************ *
 *                                                    SDL KEYWORD DEFINITION:
 * ************************************************************************************ *
 * PARENT
 * SELF
 * OFFSPRING
 * SENDER
 ************************************************************************************* *
 *                                                 TASK ENTRY POINT DEFINITION
 ************************************************************************************* *
 * RTDS_TASK_ENTRY_POINT
 * ************************************************************************************ *
 *                                                             MEMORY MACROS
 * ************************************************************************************ *
 * MACRO RTDS_MALLOC:
 * MACRO RTDS_FREE:
 * MACRO RTDS_MEMCPY
 * ************************************************************************************ *
 *                                                             TIMER MACROS
 * ************************************************************************************ *
 * MACRO RTDS_RESET_TIMER:
 * MACRO RTDS_SET_TIMER:
 * ************************************************************************************ *
 *                                                             MESSAGE MACROS
 * ************************************************************************************ *
 * MACRO RTDS_MSG_QUEUE_READ: (*)
 * MACRO RTDS_MSG_QUEUE_SEND_TO_ID: (*)
 * MACRO RTDS_MSG_QUEUE_SEND_TO_ENV: (*)
 * MACRO RTDS_MSG_QUEUE_SEND_TO_NAME: (*)
 * MACRO RTDS_MSG_SAVE:
 *
 * (*): Not implemented; no message queues in fully scheduled systems
 * ************************************************************************************ *
 *                                                             SEMAPHORE MACROS
 * ************************************************************************************ *
 * MACRO RTDS_BINARY_SEMAPHORE_CREATE:
 * MACRO RTDS_MUTEX_SEMAPHORE_CREATE:
 * MACRO RTDS_COUNTING_SEMAPHORE_CREATE:
 * MACRO RTDS_SEMAPHORE_DELETE:
 * MACRO RTDS_SEMAPHORE_ID_TAKE:
 * MACRO RTDS_SEMAPHORE_NAME_TAKE:
 * MACRO RTDS_SEMAPHORE_GIVE:
 * ************************************************************************************ *
 *                                                             PROCESS MACROS
 * ************************************************************************************ *
 * MACRO RTDS_PROCESS_CREATE: (*)
 * MACRO RTDS_STARTUP_PROCESS_CREATE: (*)
 * MACRO RTDS_PROCESS_KILL: (*)
 *
 * (*): Not implemented; all these operations happen within the scheduler and do not
 *      need a macro.
 * ************************************************************************************ *
 *                                                            FINITE STATE MACHINE
 * ************************************************************************************ *
 * MACRO RTDS_PROCEDURE_CLEAN_UP
 * MACRO RTDS_TIMER_CLEAN_UP
 * MACRO RTDS_SDL_STATE_SET
 *
 * ************************************************************************************ */

#include "RTDS_OS.h"

#ifdef RTDS_BACK_TRACE_MAX_EVENT_NUM
#include "RTDS_BackTrace.h"
#endif

#if defined( RTDS_FORMAT_TRACE )
#include "RTDS_FormatTrace.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

/*
 * SDL KEYWORD DEFINITION:
 * -------------------
 * Defines the SDL PARENT keyword. parentQueueId is given when taskSpawn is done.
 */
#define PARENT    RTDS_currentContext->parentSdlInstanceId
#define SELF      RTDS_currentContext->mySdlInstanceId
#define OFFSPRING RTDS_currentContext->offspringSdlInstanceId
#define SENDER    RTDS_senderId

/************************************************************************************* *
 *                                    TASK ENTRY POINT DEFINITION
 ************************************************************************************* */
#define RTDS_TASK_ENTRY_POINT( TASK_NAME ) \
    void TASK_NAME( RTDS_GlobalProcessInfo * RTDS_currentContext )

#define RTDS_TASK_ENTRY_POINT_PROTO( TASK_NAME ) extern RTDS_TASK_ENTRY_POINT( TASK_NAME )

/* ************************************************************************************ *
 *                                                         MEMORY MACROS                                                                *
 * ************************************************************************************ */
/*
 * MACRO RTDS_MALLOC:
 * ---------------------
 * Memory allocation
 */
#define RTDS_MALLOC( SIZE ) \
    malloc( SIZE );


/*
 * MACRO RTDS_FREE:
 * -------------------
 * Memory liberation
 */
#define RTDS_FREE( PTR )    \
    free( PTR ); 


/*
 * MACRO RTDS_MEMCPY:
 * ---------------------
 * Memory copy
 */
#define RTDS_MEMCPY( DEST , SRC , SIZE )    memcpy( DEST , SRC , SIZE )

/* ************************************************************************************ *
 *                                                         TIMER MACROS
 * ************************************************************************************ */

/*
 * MACRO RTDS_RESET_TIMER:
 * --------------------------
 * Cancels a timer
 */
/*
** TEMPORARY: Disable the macro. Timers are not handled yet...
**
** #define RTDS_RESET_TIMER( TIMER_NUMBER ) \
**     RTDS_StopTimer( TIMER_NUMBER , &( RTDS_currentContext->timerList ) , RTDS_currentContext );
*/
#define RTDS_RESET_TIMER( TIMER_NUMBER ) \
    RTDS_StopTimer(RTDS_currentContext, TIMER_NUMBER)

/*
 * MACRO RTDS_SET_TIMER:
 * ------------------------
 * Initializes and starts a timer
 */
/*
** TEMPORARY: Disable the macro. Timers are not handled yet...
**
** #define RTDS_SET_TIMER( TIMER_NUMBER , DELAY ) RTDS_RESET_TIMER( TIMER_NUMBER );\
**     RTDS_StartTimer( RTDS_currentContext->myId , TIMER_NUMBER , RTDS_GetTimerUniqueId( RTDS_currentContext->timerList ) ,DELAY, &( RTDS_currentContext->timerList ) , RTDS_currentContext );
*/
#define RTDS_SET_TIMER( TIMER_NUMBER , DELAY ) \
    RTDS_StopTimer(RTDS_currentContext, TIMER_NUMBER); \
    RTDS_StartTimer(RTDS_currentContext, TIMER_NUMBER, RTDS_GetTimerUniqueId(), DELAY)


/* ************************************************************************************ *
 *                                                         MESSAGE MACROS
 * ************************************************************************************ */

/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_ID:
 * ----------------------------------
 * Sends a message to a process's message queue using its queue id.
 */
#define RTDS_MSG_QUEUE_SEND_TO_ID(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER)

/*
 * MACRO RTDS_MSG_QUEUE_SEND_TO_NAME:
 * ------------------------------------
 * Sends a message to a process's message queue using its name.
 */
#define RTDS_MSG_QUEUE_SEND_TO_NAME(MESSAGE_NUMBER, LENGTH_DATA, P_DATA, RECEIVER_STRING, RECEIVER_NUMBER)

/*
 * MACRO RTDS_MSG_SAVE:
 * -----------------------
 * Saves a message to the save queue chained list
 */
#define RTDS_MSG_SAVE(CURRENT_MESSAGE) \
    RTDS_SIMULATOR_TRACE(RTDS_messageSaved, CURRENT_MESSAGE, SELF, RTDS_currentContext); \
    CURRENT_MESSAGE->next=NULL; \
    if ( RTDS_currentContext->writeSaveQueue == NULL ) \
      { \
      RTDS_currentContext->writeSaveQueue = (RTDS_MessageHeader*)RTDS_MALLOC(sizeof(RTDS_MessageHeader)); \
      memcpy(RTDS_currentContext->writeSaveQueue, CURRENT_MESSAGE, sizeof(RTDS_MessageHeader)); \
      } \
    else \
      { \
      RTDS_MessageHeader * RTDS_MSG_SAVE_message; \
      RTDS_MSG_SAVE_message = RTDS_currentContext->writeSaveQueue; \
      while ( RTDS_MSG_SAVE_message->next != NULL ) RTDS_MSG_SAVE_message = RTDS_MSG_SAVE_message->next; \
      RTDS_MSG_SAVE_message->next = (RTDS_MessageHeader*)RTDS_MALLOC(sizeof(RTDS_MessageHeader)); \
      memcpy(RTDS_MSG_SAVE_message->next, CURRENT_MESSAGE, sizeof(RTDS_MessageHeader)); \
      } \
    CURRENT_MESSAGE = NULL;

/*
 * MACRO RTDS_MSG_INPUT_ERROR:
 * --------------------------
 * Macro called in the generated code if the pointer on the received parameters is NULL.
 */

#define RTDS_MSG_INPUT_ERROR \
    RTDS_SYSTEM_ERROR(RTDS_ERROR_MSG_INPUT);


/* ************************************************************************************ *
 *                                                    SEMAPHORE MACROS
 * ************************************************************************************ */

/* Creation & take options */
#define RTDS_SEMAPHORE_TIME_OUT_FOREVER  -1   /* Time out option when taking the semaphore : wait forever */
#define RTDS_SEMAPHORE_TIME_OUT_NO_WAIT  0    /* Time out option when taking the semaphore : no wait */
#define RTDS_SEMAPHORE_OPTION_PRIO       0    /* Semaphore creation option: queuing based on priority (unused here) */
#define RTDS_SEMAPHORE_OPTION_FIFO       0    /* Semaphore creation option: queuing based on FIFO (always here) */
#define RTDS_BINARY_SEM_INITIAL_EMPTY    0    /* Binary semaphore creation initial state: empty */
#define RTDS_BINARY_SEM_INITIAL_FULL     1    /* Binary semaphore creation initial state: full */
#define RTDS_MUTEX_SEM_DELETE_SAFE       0    /* Protects a task that owns the semaphore from unexpected deletion (unused) */
#define RTDS_MUTEX_SEM_INVERSION_SAFE    0    /* Protect the system from priority inversion (unused) */

/*
** MACRO RTDS_BINARY_SEMAPHORE_CREATE:
** -----------------------------------
** Creates a binary semaphore.
*/
#define RTDS_BINARY_SEMAPHORE_CREATE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, IGNORED_OPTIONS, INITIAL_STATE) \
  RTDS_SemaphoreRegister( RTDS_parentScheduler, SEMAPHORE_NUMBER, RTDS_BinarySemaphoreCreate(RTDS_parentScheduler, INITIAL_STATE), RTDS_currentContext )

/*
** MACRO RTDS_MUTEX_SEMAPHORE_CREATE:
** ----------------------------------
** Creates a mutex semaphore.
*/
#define RTDS_MUTEX_SEMAPHORE_CREATE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, OPTIONS) \
  RTDS_SemaphoreRegister( RTDS_parentScheduler, SEMAPHORE_NUMBER, RTDS_MutexSemaphoreCreate(RTDS_parentScheduler), RTDS_currentContext )

/*
** MACRO RTDS_COUNTING_SEMAPHORE_CREATE:
** -------------------------------------
** Creates a counting semaphore.
*/
#define RTDS_COUNTING_SEMAPHORE_CREATE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, OPTIONS, INITIAL_COUNT) \
  RTDS_SemaphoreRegister( RTDS_parentScheduler, SEMAPHORE_NUMBER, RTDS_CountingSemaphoreCreate(RTDS_parentScheduler, INITIAL_COUNT), RTDS_currentContext )

/*
** MACROS RTDS_SEMAPHORE_DELETE & RTDS_SEMAPHORE_NAME_DELETE:
** ----------------------------------------------------------
** Delete a semaphore identified by its id or by its name
*/
#define RTDS_SEMAPHORE_DELETE(SEMAPHORE_ID)
#define RTDS_SEMAPHORE_NAME_DELETE(SEMAPHORE_NAME, SEMAPHORE_NUMBER)

/*
** MACROS RTDS_SEMAPHORE_ID_TAKE & RTDS_SEMAPHORE_NAME_TAKE:
** ---------------------------------------------------------
** Takes a semaphore identified by its id or by its name
*/
#define RTDS_SEMAPHORE_ID_TAKE(SEMAPHORE_ID, TIME_OUT) RTDS_OK
#define RTDS_SEMAPHORE_NAME_TAKE(SEMAPHORE_NAME, SEMAPHORE_NUMBER, TIME_OUT) RTDS_OK

/*
** MACROS RTDS_SEMAPHORE_ID_GIVE & RTDS_SEMAPHORE_NAME_GIVE:
** ---------------------------------------------------------
** Gives a semaphore identified by its id or by its name
*/
#define RTDS_SEMAPHORE_ID_GIVE(SEMAPHORE_ID)
#define RTDS_SEMAPHORE_NAME_GIVE(SEMAPHORE_NAME, SEMAPHORE_NUMBER)


/* ************************************************************************************ *
 *                                                 FINITE STATE MACHINE
 * ************************************************************************************ */

/*
 * MACRO RTDS_PROCEDURE_CLEAN_UP:
 * ------------------------------
 * Macro called at the end of a procedure to free last message and re-organize
 * save queue if procedure contained states.
 */
#define RTDS_PROCEDURE_CLEAN_UP \
    RTDS_TransitionCleanUp( RTDS_currentContext, 0 );

/*
 * MACRO RTDS_TIMER_CLEAN_UP:
 * --------------------------
 * Macro called when the last received message is a timer to figure out if timer
 * was cancelled
 */
#define RTDS_TIMER_CLEAN_UP(CURRENT_CONTEXT) \
    RTDS_TimerCleanUp(CURRENT_CONTEXT)

/*
 * MACRO RTDS_SDL_STATE_SET:
 * -----------------------------
 * Sets the SDL state of the current process
 */
#define RTDS_SDL_STATE_SET(NEW_SDL_STATE) \
    RTDS_currentContext->sdlState = NEW_SDL_STATE; \
    RTDS_SIMULATOR_TRACE(RTDS_sdlStateSet, RTDS_currentContext->processId, NEW_SDL_STATE, RTDS_currentContext);

/*
 * MACRO RTDS_INFORMATION:
 * -----------------------
 * To display informal message in trace
 */
#define RTDS_INFORMATION(MESSAGE) \
    RTDS_SIMULATOR_TRACE(RTDS_information, MESSAGE, 0, RTDS_currentContext)


/* ************************************************************************************ *
 *                                    COVERAGE INFORMATION
 * ************************************************************************************ *
 * The coverage information is stored in an array of unsigned char. The SDL-RT symbol
 * number is used as an index; the value stored is the number of times the symbol has
 * been executed. It can not exceed 0xFF for each symbol.
 * ************************************************************************************ */
#ifdef RTDS_COVERAGE_NB_SYMBOLS
#define RTDS_COVERAGE_DECL        unsigned char  RTDS_globalCoverage[RTDS_COVERAGE_NB_SYMBOLS];
#define RTDS_COVERAGE_PROTO     extern RTDS_COVERAGE_DECL;
#define RTDS_COVERAGE_INIT \
    { \
    int RTDS_i; \
    for (RTDS_i=0;RTDS_i<RTDS_COVERAGE_NB_SYMBOLS;RTDS_i++) \
        RTDS_globalCoverage[RTDS_i]=0; \
    }
#define RTDS_COVERAGE_LOG(SYMBOL_NUMBER) \
    if (RTDS_globalCoverage[SYMBOL_NUMBER]!=0xFF) RTDS_globalCoverage[SYMBOL_NUMBER]++;
#else
#define RTDS_COVERAGE_DECL
#define RTDS_COVERAGE_PROTO
#define RTDS_COVERAGE_INIT
#endif


/* ************************************************************************************ *
 *                                             CRITICAL SECTION MACROS                                                        *
 * ************************************************************************************ */
#define RTDS_CRITICAL_SECTION_START
#define RTDS_CRITICAL_SECTION_STOP

#ifndef RTDS_ENABLE_INTERRUPTS
#define RTDS_ENABLE_INTERRUPTS
#endif

#ifndef RTDS_DISABLE_INTERRUPTS
#define RTDS_DISABLE_INTERRUPTS
#endif

#ifndef RTDS_START_SYNCHRO_WAIT
#define RTDS_START_SYNCHRO_WAIT
#endif

/*
 * DEFINE FOR TIMER MANIPULATION:
 * ------------------------------
 */
#define RTDS_TIMER_OK         1
#define RTDS_TIMER_NA         2
#define RTDS_TIMER_CANCELLED  0


/*
 * DEFINE FOR SIMULATION:
 * ------------------------------
 * Define on how many bytes the messageUniqueId pool will be made of
 * 1 means 1 byte means 1*8 bits means 8 possible simultaneous values
 * Maximum is 8192 since the id a long type
 */
#if defined(RTDS_SIMULATOR)
#define RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE    64
#endif

/*
 * DEFINE FOR SIMULATION:
 * ----------------------
 */
#if defined(RTDS_SIMULATOR) || defined(RTDS_FORMAT_TRACE)
    /* Number of levels when formatting message parameters to be printable
     * in the SDL-RT debugger */
#ifndef RTDS_PARAM_CODEC_MAX_DEPTH
 #define RTDS_PARAM_CODEC_MAX_DEPTH             4
#endif
    /* Min size of memory chunk used when formatting message parameters
     * to be printable in the SDL-RT debugger */
#ifndef RTDS_PARAM_CODEC_CHUNK_SIZE
 #define RTDS_PARAM_CODEC_CHUNK_SIZE            128
#endif
#endif



/* Defines when tracing through socket to synchronize target execution and host debugger */
#define RTDS_DTRACE_ACK_NOWAIT              0     /* No acknowledgment from the host */
#define RTDS_DTRACE_ACK_WAIT                1     /* Ack from the host */


#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACER)
    #define RTDS_SIMULATOR_TRACE(EVENT, PARAM1, PARAM2, RTDS_CURRENT_CONTEXT) \
        RTDS_SimulatorTrace((enum RTDS_EventType)EVENT, (void *)PARAM1, (long)PARAM2, (RTDS_GlobalProcessInfo *)RTDS_CURRENT_CONTEXT, RTDS_DTRACE_ACK_WAIT);
#else
    #define RTDS_SIMULATOR_TRACE(EVENT, PARAM1, PARAM2, RTDS_CURRENT_CONTEXT)
#endif

#define RTDS_SOCKET_ACCESS_DECL
#define RTDS_SOCKET_ACCESS_PROTO
#define RTDS_SOCKET_ACCESS_INIT
#define RTDS_SOCKET_ACCESS_TAKE
#define RTDS_SOCKET_ACCESS_GIVE

#define RTDS_DTRACE_ACKNOWLEDGE_DECL
#define RTDS_DTRACE_ACKNOWLEDGE_PROTO
#define RTDS_DTRACE_ACKNOWLEDGE_INIT
#define RTDS_DTRACE_ACKNOWLEDGE_WAIT
#define RTDS_DTRACE_ACKNOWLEDGE_RECEIVED


/*
 * MACRO RTDS_SYSTEM_ERROR:
 * ------------------------
 * Macro called when a system error is detected in RTDS 'kernel'
 * Needs to be defined by user.
 *
 *    For printing in the std output include "stdio.h" and remove this comment
 *        printf("RTDS error 0x%x\nCheck RTDS_Error.h file for explanations.\n",errorNumber); \
 */
#define RTDS_GET_CURRENTPROCESS()    0
#define RTDS_GET_PROCESSINFO(PROCID) NULL

#define RTDS_SYSTEM_ERROR(errorNumber) \
    { \
    RTDS_SIMULATOR_TRACE(RTDS_systemError, errorNumber, RTDS_NONE, RTDS_SystemScheduler->currentContext); \
    exit(errorNumber); \
    }


#ifdef __cplusplus
}
#endif

#endif /* End of    _RTDS_MACRO_H_ */

