#ifndef _RTDS_ADDL_MACRO_H_
#define _RTDS_ADDL_MACRO_H_

#include "RTDS_OS.h"

/*
** MACRO RTDS_CREATE_TASK:
** -----------------------
** "Creates a task" running a scheduler; used in RTDS_Start.c to run the initial
** schedulers. As we always are in a fully scheduled system, no "task" is created
** and the scheduler is run directly.
*/
#define RTDS_CREATE_TASK(TASK_PRIORITY, TASK_FUNCTION, FUNCTION_PARAMETER) \
  (*TASK_FUNCTION)(FUNCTION_PARAMETER)


/*
** MACRO RTDS_FORGET_INSTANCE_INFO:
** --------------------------------
** Removes the descriptor for the instance from the global chained list
*/
#define RTDS_FORGET_INSTANCE_INFO \
  RTDS_ProcessForget( RTDS_currentContext )


/*
** MACRO RTDS_NEW_MESSAGE_QUEUE:
** -----------------------------
** Creates a new message queue and returns it.
*/
#define RTDS_NEW_MESSAGE_QUEUE \
  RTDS_MsgQCreate()


/*
** MACRO RTDS_READ_MESSAGE_QUEUE:
** ------------------------------
** Blocking read on a message queue. Here, just waits for an external message to
** arrive.
*/
#define RTDS_READ_MESSAGE_QUEUE(QUEUE, MESSAGE) \
  RTDS_Wait4ExternalMessage( MESSAGE )


/*
** MACRO RTDS_SETUP_CURRENT_CONTEXT:
** ---------------------------------
** Sets up the current process instance context from the task function parameters.
** Here, the context is passed as a parameter and nothing else is needed.
*/
#define RTDS_SETUP_CURRENT_CONTEXT


/*
** MACROS RTDS_GET_MESSAGE_UNIQUE_ID & RTDS_RELEASE_MESSAGE_UNIQUE_ID:
** -------------------------------------------------------------------
** Handling of unique identifiers for messages when running in the debugger
*/
#ifdef RTDS_SIMULATOR
  #define RTDS_GET_MESSAGE_UNIQUE_ID RTDS_GetMessageUniqueId()
  #define RTDS_RELEASE_MESSAGE_UNIQUE_ID(UniqueId) RTDS_ReleaseMessageUniqueId(UniqueId)
#else
  #define RTDS_GET_MESSAGE_UNIQUE_ID 0
  #define RTDS_RELEASE_MESSAGE_UNIQUE_ID(UniqueId)
#endif 

#endif
