/* *************************************************************** */
/* $(RTDS_HOME)/share/ccg/posix/bricks/RTDS_Startup_end.c begins */
/* PragmaDev RTDS posix integration */

    RTDS_SIMULATOR_TRACE( RTDS_initDone , NULL , (long int) NULL , RTDS_currentContext );

    /* Let all the created process run now */
    RTDS_START_SYNCHRO_GO;

    /* To avoid the master creator thread to exit */

    #ifndef RTDS_MAIN
    while ( 1 )
        {
        sleep( 3600 );
        }
    #endif
    }

/* **************************************************************** *
 *    RTDS_StopProgram
 * **************************************************************** *
 *    Function for stopping program using breakpoint and
 *    command interpreter Client
 * **************************************************************** */
void RTDS_StopProgram( void )
    {
    }

/* **************************************************************** *
 *    main
 * **************************************************************** *
 *    Main entry
 * **************************************************************** */
#ifndef RTDS_MAIN
int main( void )
#else
int RTDS_MAIN( void )
#endif
    {
    int socketEnable = 0;

    #ifdef RTDS_CMD_INTERPRETER
        enum RTDS_CmdType commandId;
        RTDS_UnionCommandParam * pCommandParam;
        /* Variable for sending SDL message*/
        RTDS_CmdSendMsg2ProcNumber *paramSendMsg2pNumber = NULL;
        RTDS_CmdSendMsg2ProcId * paramSendMsg2pId = NULL;
        RTDS_SdlInstanceId * receiver;
        RTDS_SdlInstanceId * sender;
        RTDS_GlobalProcessInfo * processInfoSender;
        RTDS_GlobalProcessInfo *processInfoReceiver;
        /* Variable for forcing timer */
        RTDS_CmdForceTimer * paramForceTimer = NULL;
        #ifdef RTDS_FORMAT_TRACE
            /* Variable for configuring trace */
            RTDS_CmdTraceConfig *paramTraceConf = NULL;
        #endif
    #endif

    #if defined ( RTDS_SOCKET_PORT ) && ( defined ( RTDS_SIMULATOR ) || defined ( RTDS_MSC_TRACER ) )
        char *currentData; /* ptr on data to read from socket */
        int currentSize; /* Data size to read from socket */

        RTDS_SOCKET_ID_TYPE clientSocketId = 0;
        RTDS_RtosTaskId commandInterThreadId;
    #endif

    RTDS_SOCKET_ACCESS_INIT;
    RTDS_CRITICAL_SECTION_INIT;
    RTDS_START_SYNCHRO_INIT;
    RTDS_CRITICAL_TRACE_SECTION_INIT;

    #if defined ( RTDS_SOCKET_PORT ) && ( defined ( RTDS_SIMULATOR ) || defined ( RTDS_MSC_TRACER ) )
        clientSocketId = RTDS_InitSocket( GET_HOSTNAME_STRING( RTDS_SOCKET_IP_ADDRESS ) , RTDS_SOCKET_PORT );
        if( !( clientSocketId == RTDS_ERROR || clientSocketId == 0 ) )
            {
            socketEnable = 1;
            /* global variable for sending data */
            globalClientSocketId = clientSocketId;
            }
        else
            {
            printf("Error. Executable could not connect to PragmaDev debugger or tracer.\n");
            exit(RTDS_ERROR_SOCKET_CONNECTION);
            }
    #endif

    #if defined( RTDS_SIMULATOR ) && defined( RTDS_CMD_INTERPRETER ) && defined( RTDS_SOCKET_PORT )
        /* Init acknowledge semaphore */
        RTDS_DTRACE_ACKNOWLEDGE_INIT;

        /* RTDS_Start is started in a  thread*/
        commandInterThreadId = RTDS_TaskCreate( RTDS_DEFAULT_TCP_CLIENT_PRIORITY , ( void *( * )( void * ) )RTDS_Start , ( void* )NULL );
        if ( socketEnable == 1 )
            {
            while( RTDS_ReadSocket( clientSocketId , &currentData , &currentSize , RTDS_CMD_DELIMITERCHAR, RTDS_ESCAPECHAR ) != -1)
                {
                if ( RTDS_InterpretCommand( currentData , &commandId , &pCommandParam ) != RTDS_ERROR )
                    {
                    /* Process command */
                    switch( commandId )
                        {
                        case ACK_CMDID:
                            RTDS_DTRACE_ACKNOWLEDGE_RECEIVED;
                            break;

                        case STOP_CMDID:
                            RTDS_StopProgram();
                            break;

                        case MSG2PROCID:
                            /* pCommandParam is a valid RTDS_CmdSendMsg2ProcId struct */
                            paramSendMsg2pId = ( RTDS_CmdSendMsg2ProcId * )pCommandParam;
                            /* Get Receiver QueueId */
                            processInfoReceiver = RTDS_GetProcessInfoFromProcessId( paramSendMsg2pId->receiver );
                            /* Get Sender QueueId*/
                            processInfoSender = RTDS_GetProcessInfoFromProcessId( paramSendMsg2pId->sender );


                            /* Ignore if receiver is not known */
                            if (processInfoReceiver == NULL)
                              {
                              break;
                              }
                            if (processInfoSender == NULL)
                              sender = NULL;
                            else
                              sender = processInfoSender->mySdlInstanceId;
                            receiver = processInfoReceiver->mySdlInstanceId;

                            RTDS_SimulatorMsgQueueSend(
                             paramSendMsg2pId->messageNumber ,
                             paramSendMsg2pId->dataLength ,
                             paramSendMsg2pId->pData ,
                             receiver ,
                             sender ,
                             processInfoSender );
                            break;

                        case MSG2PROCNUM:
                            /* pCommandParam is a valid RTDS_CmdSendMsg2ProcNumber struct */
                            paramSendMsg2pNumber = ( RTDS_CmdSendMsg2ProcNumber * )pCommandParam;
                            /* Get Sender QueueId*/
                            processInfoSender = RTDS_GetProcessInfoFromProcessNum( paramSendMsg2pNumber->sender );

                            RTDS_SimulatorMsgQueueSend(
                             paramSendMsg2pNumber->messageNumber ,
                             paramSendMsg2pNumber->dataLength ,
                             paramSendMsg2pNumber->pData ,
                             RTDS_GetProcessQueueId( paramSendMsg2pNumber->receiver ) ,
                             RTDS_GetProcessQueueId( paramSendMsg2pNumber->sender ) ,
                             processInfoSender );
                            break;

                        case TIMER_CMDID:
                            /* pCommandParam is a valid RTDS_CmdForceTimer struct */
                            paramForceTimer = ( RTDS_CmdForceTimer * )pCommandParam;
                            RTDS_ForceTimer( paramForceTimer->pId , paramForceTimer->timerNum );
                            break;

                        case SYSCLOCK_CMDID:
                            RTDS_SetSystemTime( ( long )pCommandParam );
                            break;

                        case TRACE_CMDID:
                            #ifdef RTDS_FORMAT_TRACE
                                paramTraceConf = ( RTDS_CmdTraceConfig * )pCommandParam;
                                RTDS_ConfigureTrace( paramTraceConf );
                            #endif
                            break;
                        case MSG2PROCNAME :
                        default :
                            break;
                        }
                    }
                RTDS_FREE( currentData );
                }
            }
    #else
        /* Call Start function (that will run SDL Task and run program) */
        RTDS_Start();
    #endif

    #ifndef RTDS_MAIN
    if ( socketEnable == 0 )
        {
        /* To avoid the main thread to exit */
        while ( 1 )
            {
            sleep( 3600 );
            }
        }
    #endif

    return 0;
    }

/* $(RTDS_HOME)/share/ccg/posix/bricks/RTDS_Startup_end.c ends */
/* ************************************************************* */

