/* PragmaDev RTDS OSE Epsilon integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* OSE includes */
#include "ose.h"
#include "ose_i.h"
#include "tosv.h"

#include <stdlib.h>
#include <stdarg.h>

/* RTDS include */
#include "RTDS_Error.h"

/* Include for RTDS types */
#include "RTDS_Common.h"


/* In OSE, all signals are of type SIGNAL. By declaring it as a union between
	 our different signal types, we get a very generic SIGNAL type that
	 is always treated the same way regardless of contents */
/* typedef RTDS_MessageHeader SIGNAL; */
typedef union SIGNAL
  {
  SIGSELECT sigNo;
  struct RTDS_MessageHeader messageHeader;
  } SIGNAL;


/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
extern RTDS_GlobalProcessInfo   *RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo *RTDS_globalSemaphoreInfo;
#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACER) || defined(RTDS_FORMAT_TRACE)
extern unsigned char            *RTDS_globalMessageUniqueIdPool;
extern RTDS_GlobalTraceInfo     RTDS_globalTraceEntry;
extern long                     RTDS_globalSystemTime;
#endif
/* extern SIGSELECT 				 any_sig[] = {0}; */

RTDS_COVERAGE_PROTO
RTDS_CRITICAL_SECTION_PROTO

/* OSE global error number */
extern unsigned int ERR_MSG[5];

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */

extern long                 RTDS_GetTimerUniqueId  ( RTDS_TimerState * );
extern void                 RTDS_WatchDogFunction  ( RTDS_TimerState * );
extern void                 RTDS_StartTimer 						 ( RTDS_SdlInstanceId * , long , long , int , RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void                 RTDS_StopTimer							  ( long , RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void                 RTDS_MsgQueueSend 					( long , long, unsigned char *, RTDS_SdlInstanceId * , RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * );
extern void                 RTDS_MsgQueueReceive			( RTDS_SdlInstanceId *, char * , int , int );
extern RTDS_SdlInstanceId * RTDS_GetProcessQueueId	( int processNumber );
extern void                 RTDS_ProcessKill						 ( RTDS_GlobalProcessInfo * );
extern void                 RTDS_Sem_Delete 						 ( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreStatus RTDS_SemaphoreIdTake			( RTDS_SemaphoreId , RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreId     RTDS_GetSemaphoreId 			( int semaphoreNumber );
extern RTDS_SemaphoreId     RTDS_Sem_Info_Insert			( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern void                 RTDS_TransitionCleanUp	( RTDS_GlobalProcessInfo *RTDS_currentContext, int RTDS_sdlStatePrev );
extern unsigned long        RTDS_GetSystemTime					( void );

#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACER) || defined(RTDS_FORMAT_TRACE)
extern unsigned long        RTDS_GetMessageUniqueId 		  ( void );
extern void                 RTDS_ReleaseMessageUniqueId ( unsigned long );
extern void                 RTDS_DummyTraceFunction 		  ( void );
extern void                 RTDS_messageDataToString		  ( char ** buffer, long messageNumber, long dataLength, void* dataPointer, int level);
extern char               * RTDS_stringToMessageData 	  ( long messageNumber, long * dataLength, void ** dataPointer, char * dataString);
extern void                 RTDS_SimulatorMsgQueueSend	 ( long messageNumber, long dataLength, unsigned char *pData, RTDS_SdlInstanceId * receiver, RTDS_SdlInstanceId * sender, RTDS_GlobalProcessInfo *RTDS_currentContext );
extern void                 RTDS_SimulatorTrace 				    ( enum RTDS_EventType  event, void *eventParameter1, long eventParameter2, RTDS_GlobalProcessInfo *currentContext, int waitAck);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
