/* PragmaDev RTDS OSE 52 integration */
#ifndef _RTDS_OS_H_
#define _RTDS_OS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* RTDS include */
#include "RTDS_Error.h"
#include "RTDS_Common.h"

/* **************************************************************** *
 * any_sig
 * **************************************************************** *
 * Specific to OSE to receive all signals when waiting for a
 * message
 * **************************************************************** */
static const SIGSELECT any_sig[ ] = { 0 };

/*
 * GLOBAL VARIABLES:
 * -------------------
 * Pointers to global list of information on processes and semaphores
 */
extern RTDS_GlobalProcessInfo   * RTDS_globalProcessInfo;
extern RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo;
#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER ) || defined( RTDS_FORMAT_TRACE )
extern unsigned char            * RTDS_globalMessageUniqueIdPool;
extern RTDS_GlobalTraceInfo     RTDS_globalTraceEntry;
extern OSTICK                   RTDS_globalSystemTime;
#endif

RTDS_COVERAGE_PROTO;
RTDS_CRITICAL_SECTION_PROTO;

/*
 * FUNCTION PROTOTYPES:
 * -------------------
 * Function defined in RTDS_OS.c used below
 */
extern void                     RTDS_MsgQueueSend( long, long, unsigned char *, RTDS_SdlInstanceId *, RTDS_SdlInstanceId *, RTDS_GlobalProcessInfo * );

extern long                     RTDS_GetTimerUniqueId( RTDS_TimerState * );
extern void                     RTDS_WatchDogFunction( RTDS_TimerState * );
extern void                     RTDS_StartTimer( RTDS_SdlInstanceId *, long, long, int, RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void                     RTDS_StopTimer( long, RTDS_TimerState **, RTDS_GlobalProcessInfo * );
extern void                     RTDS_TimerCleanUp( RTDS_GlobalProcessInfo * currentContext );
extern unsigned long            RTDS_GetSystemTime( void );

extern void *                   RTDS_MemAlloc( int size );
extern void                     RTDS_Free( void * );
extern void                     RTDS_TransitionCleanUp( RTDS_GlobalProcessInfo *, int RTDS_sdlStatePrev );

extern RTDS_SdlInstanceId *     RTDS_GetProcessQueueId( int processNumber );
extern void                     RTDS_ProcessCreate( char * processName, int processNumber, void *, int, RTDS_SdlInstanceId **, RTDS_SdlInstanceId *, short, RTDS_GlobalProcessInfo * );
extern void                     RTDS_ProcessKill( RTDS_GlobalProcessInfo * );
extern RTDS_RtosTaskId          RTDS_ProcessForget( RTDS_GlobalProcessInfo * );

extern RTDS_SemaphoreId         RTDS_GetSemaphoreId( int semaphoreNumber );
extern RTDS_SemaphoreId         RTDS_Semaphore_Create( int initialCount, RTDS_SemaphoreType type );
extern RTDS_SemaphoreId         RTDS_Sem_Info_Insert( int semaphoreNumber, RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern void                     RTDS_Sem_Delete( RTDS_SemaphoreId, RTDS_GlobalProcessInfo * );
extern RTDS_SemaphoreStatus     RTDS_SemaphoreIdTake( RTDS_SemaphoreId, RTDS_SemaphoreTimeout, RTDS_GlobalProcessInfo * RTDS_currentContext );
extern void                     RTDS_SemaphoreTake( RTDS_SemaphoreId, RTDS_SemaphoreTimeout );
extern void                     RTDS_SemaphoreIdGive( RTDS_SemaphoreId );
extern OSSEMVAL                 RTDS_GetSemaphoreValue( RTDS_SemaphoreId semaphoreId );

extern void RTDS_Main( void );
extern void RTDS_Start( void );

#if defined( RTDS_SIMULATOR ) || defined( RTDS_MSC_TRACER ) || defined( RTDS_FORMAT_TRACE )
extern unsigned long        RTDS_GetMessageUniqueId( void );
extern void                 RTDS_ReleaseMessageUniqueId ( unsigned long );
extern void                 RTDS_DummyTraceFunction( void );
extern void                 RTDS_messageDataToString( char ** buffer, long messageNumber, long dataLength, void * dataPointer, int level );
extern char *               RTDS_stringToMessageData( long messageNumber, long * dataLength, void ** dataPointer, char * dataString );
extern void                 RTDS_SimulatorMsgQueueSend( long messageNumber, long dataLength, unsigned char * pData, RTDS_SdlInstanceId * receiver, RTDS_SdlInstanceId * sender, RTDS_GlobalProcessInfo * RTDS_currentContext );
extern void                 RTDS_SimulatorTrace( enum RTDS_EventType event, void * eventParameter1, long eventParameter2, RTDS_GlobalProcessInfo * currentContext, int waitAck );
#endif

#ifdef __cplusplus
}
#endif

#endif /* _RTDS_OS_H_ */
