/* PragmaDev RTDS OSE 52 integration */
#include "RTDS_OS.h"
#include "RTDS_MACRO.h"
#include "RTDS_gen.h"

/*
 * FUNCTION FOR PROCESS RTDS_Env:
 * ------------------------------
 */
RTDS_TASK_ENTRY_POINT( RTDS_Env )
    {
    RTDS_GlobalProcessInfo * RTDS_currentContext = NULL;
    
    /* Get the task context from RTDS_globalProcessInfo chained list */
    RTDS_CRITICAL_SECTION_START;
        {
        RTDS_RtosTaskId RTDS_taskId;
        
        RTDS_taskId = current_process();
        for ( RTDS_currentContext = RTDS_globalProcessInfo; RTDS_currentContext->next != NULL; RTDS_currentContext = RTDS_currentContext->next )
            {
            if ( RTDS_currentContext->myRtosTaskId == RTDS_taskId )
                {
                break;
                }
            }
        }
    RTDS_CRITICAL_SECTION_STOP;
    
    RTDS_SDL_STATE_SET( RTDS_state_RTDS_Idle );
    
    /* Event loop */
    for ( ; ; )
        {
        /* Get message from process's message queue */
        RTDS_MSG_QUEUE_READ( RTDS_currentContext->currentMessage );
        RTDS_currentContext->currentMessage->next = NULL;
        
    #ifdef RTDS_SIMULATOR
        RTDS_messageDataToString(
        &RTDS_globalPrintableParameters,
        RTDS_currentContext->currentMessage->messageNumber,
        RTDS_currentContext->currentMessage->dataLength,
        ( void * )( RTDS_currentContext->currentMessage->pData ),
        RTDS_PARAM_CODEC_MAX_DEPTH );
        
        RTDS_SIMULATOR_TRACE( RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext );
        RTDS_FREE( RTDS_globalPrintableParameters );
        RTDS_globalPrintableParameters = NULL;
        /* Release the message unique id back to the pool */
        RTDS_ReleaseMessageUniqueId( RTDS_currentContext->currentMessage->messageUniqueId );
    #endif

    #ifdef RTDS_ENV_FREE_PARAMETER
        if ( RTDS_currentContext->currentMessage->pData != NULL )
            {
            RTDS_FREE( RTDS_currentContext->currentMessage->pData );
            }
    #endif

        /* Free memory */
        free_buf( ( union SIGNAL ** )&( RTDS_currentContext->currentMessage ) );
        RTDS_currentContext->currentMessage = NULL;
        } /* End of for ( ; ; ) */
    
    /* Resources clean up */
    RTDS_PROCESS_KILL;
    }

