/* PragmaDev RTDS OSE Delta integration */

#ifdef RTDS_SOCKET_PORT

#ifdef __cplusplus
extern "C" {
#endif

#include "RTDS_MACRO.h"
#ifdef RTDS_FORMAT_TRACE
	#include "RTDS_FormatTrace.h"
#endif
#ifdef RTDS_CMD_INTERPRETER
	#include "RTDS_CmdInterpreter.h"
#endif

#define TO_STRING(X) #X
#define GET_HOSTNAME_STRING(X) TO_STRING(X)

#define RTDS_TRACE_BUFFER_SIZE	1024

#if (defined(RTDS_SIMULATOR)|| defined(RTDS_MSC_TRACER))
	#define RTDS_SOCKET_ACCESS_DECL 						RTDS_SemaphoreId RTDS_globalSocketAccess;
	#define RTDS_SOCKET_ACCESS_PROTO						extern RTDS_SemaphoreId RTDS_globalSocketAccess;
	#define RTDS_SOCKET_ACCESS_INIT 						RTDS_globalSocketAccess = create_sem( 1 );
	#define RTDS_SOCKET_ACCESS_TAKE 						wait_sem( RTDS_globalSocketAccess );
	#define RTDS_SOCKET_ACCESS_GIVE 						signal_sem( RTDS_globalSocketAccess);
#else
	#define RTDS_SOCKET_ACCESS_DECL
	#define RTDS_SOCKET_ACCESS_PROTO
	#define RTDS_SOCKET_ACCESS_INIT
	#define RTDS_SOCKET_ACCESS_TAKE
	#define RTDS_SOCKET_ACCESS_GIVE
#endif

#if defined(RTDS_SIMULATOR)
	#define RTDS_DTRACE_ACKNOWLEDGE_DECL				RTDS_SemaphoreId RTDS_globalTcpEventSynchro;
	#define RTDS_DTRACE_ACKNOWLEDGE_PROTO 			extern RTDS_SemaphoreId RTDS_globalTcpEventSynchro;
	#define RTDS_DTRACE_ACKNOWLEDGE_INIT				RTDS_globalTcpEventSynchro = create_sem( 1 );
	#define RTDS_DTRACE_ACKNOWLEDGE_WAIT				wait_sem( RTDS_globalTcpEventSynchro );
	#define RTDS_DTRACE_ACKNOWLEDGE_RECEIVED		signal_sem( RTDS_globalTcpEventSynchro);
#else
	#define RTDS_DTRACE_ACKNOWLEDGE_DECL
	#define RTDS_DTRACE_ACKNOWLEDGE_PROTO
	#define RTDS_DTRACE_ACKNOWLEDGE_INIT
	#define RTDS_DTRACE_ACKNOWLEDGE_WAIT
	#define RTDS_DTRACE_ACKNOWLEDGE_RECEIVED
#endif

/* ************************************************************************************ *
 *												CRITICAL TRACE SECTION MACROS 										*
 * ************************************************************************************ */
#ifdef RTDS_SIMULATOR
	#define RTDS_CRITICAL_TRACE_SECTION_DECL			RTDS_SemaphoreId RTDS_globalTraceSemId;
	#define RTDS_CRITICAL_TRACE_SECTION_PROTO 		extern RTDS_SemaphoreId RTDS_globalTraceSemId;
	#define RTDS_CRITICAL_TRACE_SECTION_INIT			RTDS_globalTraceSemId = create_sem( 1 );
	#define RTDS_CRITICAL_TRACE_SECTION_START 		wait_sem( RTDS_globalTraceSemId );
	#define RTDS_CRITICAL_TRACE_SECTION_STOP			signal_sem( RTDS_globalTraceSemId );
#else
	#define RTDS_CRITICAL_TRACE_SECTION_DECL
	#define RTDS_CRITICAL_TRACE_SECTION_PROTO
	#define RTDS_CRITICAL_TRACE_SECTION_INIT
	#define RTDS_CRITICAL_TRACE_SECTION_START
	#define RTDS_CRITICAL_TRACE_SECTION_STOP
#endif


typedef int RTDS_SocketId;

enum RTDS_Trace_Mode{
	normal,
	escape,
	complete
	};

extern void RTDS_InitSocket(void);
extern void RTDS_SendSocket(char *buffer, long dataLength);
extern void RTDS_CloseSocket(void);
RTDS_TASK_ENTRY_POINT_PROTO(RTDS_SocketProcess);

RTDS_DTRACE_ACKNOWLEDGE_PROTO
RTDS_SOCKET_ACCESS_PROTO
RTDS_CRITICAL_TRACE_SECTION_PROTO

#ifdef __cplusplus
}
#endif

#endif /* RTDS_SOCKET_PORT */
