                /* *************************************************************** */
                /* $(RTDS_HOME)/share/ccg/nucleus/bricks/RTDS_Proc_middle.c begins */
                /* PragmaDev RTDS Nucleus integration                              */

                /* Check saved messages */
                if ( RTDS_currentContext->readSaveQueue != NULL )
                    {
                    RTDS_currentContext->currentMessage = RTDS_currentContext->readSaveQueue;
                    RTDS_currentContext->readSaveQueue = RTDS_currentContext->readSaveQueue->next;
                    }
                /* If no saved messages left, get message from process's message queue */
                else
                    {
                    RTDS_currentContext->currentMessage = ( RTDS_MessageHeader * )RTDS_MALLOC( sizeof( RTDS_MessageHeader ) );
                    RTDS_MSG_QUEUE_READ( RTDS_currentContext->currentMessage );
                    }

                /* Discard cancelled timers */
                if ( RTDS_currentContext->currentMessage->timerUniqueId != 0 )
                    {
                    RTDS_prevTimer = NULL;
                    for ( RTDS_timer = RTDS_currentContext->timerList; RTDS_timer != NULL; RTDS_timer = RTDS_timer->next )
                        {
                        /* If timer found and cancelled */
                        if ( RTDS_timer->timerUniqueId == RTDS_currentContext->currentMessage->timerUniqueId )
                            {
                            if ( RTDS_timer->state == RTDS_TIMER_CANCELLED )
                                {
                                /* Discard current message */
                                RTDS_FREE( RTDS_currentContext->currentMessage );
                                RTDS_currentContext->currentMessage = NULL;
                                }
                            
                            /* Remove it from list of timers */
                            if ( RTDS_prevTimer == NULL )
                                {
                                RTDS_currentContext->timerList = RTDS_currentContext->timerList->next;
                                }
                            else
                                {
                                RTDS_prevTimer->next = RTDS_timer->next;
                                }
                            
                            /* Before delete the timer we try to cancel it */
                            if ( NU_Control_Timer( RTDS_timer->watchDogId, NU_DISABLE_TIMER ) != NU_SUCCESS )
                                {
                                RTDS_SYSTEM_ERROR( RTDS_ERROR_CANCEL_TIMER );
                                }
                            /* Deallocate previously allocated memory */
                            RTDS_FREE( RTDS_timer->watchDogParam );
                            RTDS_timer->watchDogParam = NULL;
                            /* And delete the timer */
                            if( NU_Delete_Timer( RTDS_timer->watchDogId ) != NU_SUCCESS )
                                {
                                RTDS_SYSTEM_ERROR( RTDS_ERROR_DELETE_WATCHDOG_ID );
                                }
                            /* Then deallocate the memory for the control block of the timer */
                            /* And the pointer of the structure */
                            RTDS_FREE( RTDS_timer->watchDogId );
                            RTDS_timer->watchDogId = NULL;
                            RTDS_FREE( RTDS_timer );
                            RTDS_timer = NULL;
                            break;
                            }
                        RTDS_prevTimer = RTDS_timer;
                        }
                    }
                
                /* Let's process the message ! */
                if ( RTDS_currentContext->currentMessage != NULL )
                    {
                #ifdef RTDS_SIMULATOR
                    RTDS_messageDataToString
                    ( &RTDS_globalPrintableParameters,
                    RTDS_currentContext->currentMessage->messageNumber,
                    RTDS_currentContext->currentMessage->dataLength,
                    ( void * )( RTDS_currentContext->currentMessage->pData ),
                    RTDS_PARAM_CODEC_MAX_DEPTH );
                    
                    RTDS_SIMULATOR_TRACE( RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext );
                    RTDS_FREE( RTDS_globalPrintableParameters );
                    RTDS_globalPrintableParameters = NULL;
                #endif
                    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
                    RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
                /* $(RTDS_HOME)/share/ccg/nucleus/bricks/RTDS_Proc_middle.c ends */
                /* ************************************************************* */

