#ifndef _RTDS_ADDL_MACRO_H_
#define _RTDS_ADDL_MACRO_H_

#include "RTDS_OS.h"

#define RTDS_CREATE_TASK( TASK_PRIORITY, TASK_FUNCTION, FUNCTION_PARAMETER ) \
    RTDS_TaskCreate( TASK_PRIORITY, TASK_FUNCTION, FUNCTION_PARAMETER )

#define RTDS_NEW_MESSAGE_QUEUE \
    RTDS_MsgQueueCreate()

#define RTDS_READ_MESSAGE_QUEUE( QUEUE, MESSAGE ) \
    RTDS_MsgQueueReceive( QUEUE, &( MESSAGE ), RTDS_QUEUE_MAX_MSG_LENGTH_IN_BYTE, NU_SUSPEND )

#define RTDS_SETUP_CURRENT_CONTEXT \
    RTDS_GlobalProcessInfo * RTDS_currentContext = NULL; \
    /* Before trying to retrieve information pass to the argv parameter */ \
    /* We have to check if the number of argument equals RTDS_TASK_OPTIONS_NUMBER */ \
    if ( option != RTDS_TASK_OPTIONS_NUMBER ) \
        { \
        RTDS_SYSTEM_ERROR( RTDS_ERROR_TASK_OPTIONS_NUMBER ); \
        } \
    RTDS_currentContext = ( RTDS_GlobalProcessInfo * )pointer;

#endif
