#ifndef _RTDS_SCHEDULER_H_
#define _RTDS_SCHEDULER_H_

#include <stdlib.h>

class RTDS_Proc;
class RTDS_Proxy;
class RTDS_SdlInstanceId;
struct RTDS_MessageHeader;
struct RTDS_TimerState;
struct RTDS_DeplComponent;

struct RTDS_ScheduledInstance
{
  RTDS_Proc                 * instanceObject;
  RTDS_ScheduledInstance    * next;
};

class RTDS_Scheduler 
{
  public:
    RTDS_DeplComponent      * component;
    unsigned int              nextInstanceNumber;
    RTDS_ScheduledInstance  * scheduledInstances;
    RTDS_TimerState         * timerList;
    RTDS_MessageHeader      * readInputQueue;
    RTDS_MessageHeader      * writeInputQueue;
    RTDS_Proc               * envInstance;
    RTDS_Proxy              * proxyInstance;

  public:
    RTDS_Scheduler(void *queueId = NULL);
    ~RTDS_Scheduler();
    void run();
    void sendMessage(RTDS_SdlInstanceId &sender, RTDS_SdlInstanceId &receiver, int messageNumber, long dataLength, unsigned char *pData, int timerUniqueId = 0);
    RTDS_SdlInstanceId &createInstance(int processNumber, RTDS_Proc *parent = NULL, RTDS_Proc *self = NULL);
};

#endif
