#include <stdlib.h>

#include "RTDS_InstanceManager.h"


RTDS_InstanceManagerList * RTDS_InstanceManager::instanceList = NULL;

RTDS_InstanceManager::RTDS_InstanceManager(int processNumber, InstanceCreationFunction creationFunction)
  {
  this->creationFunction = creationFunction;
  RTDS_InstanceManagerList *listElement = (RTDS_InstanceManagerList *) malloc(sizeof(RTDS_InstanceManagerList));
  listElement->processNumber = processNumber;
  listElement->manager = this;
  listElement->next = instanceList;
	instanceList = listElement;
  }

RTDS_InstanceManager::~RTDS_InstanceManager()
  {
  // Remove manager from list
  RTDS_InstanceManagerList *currElement, *prevElement = NULL;
  for (currElement = instanceList; currElement != NULL; prevElement = currElement, currElement = currElement->next)
    {
    if (currElement->manager == this)
      {
        if (prevElement == NULL)
          {
          instanceList = currElement->next;
          }
        else
          {
          prevElement->next = currElement->next;
          }
        free(currElement);
        break;
      }
    }
  }

RTDS_Proc* RTDS_InstanceManager::createInstance(RTDS_Scheduler *parentScheduler, int processNumber) 
  {
  RTDS_InstanceManagerList *listElement = NULL;
  for (listElement = instanceList; listElement != NULL; listElement = listElement->next)
    {
    if (listElement->processNumber == processNumber)
      {
      return listElement->manager->creationFunction(parentScheduler);
      }
    }
  // Should not happen
  return NULL;
  }
