#include <stdlib.h>

#include "RTDS_Common.h"


RTDS_SdlInstanceId::RTDS_SdlInstanceId()
  {
  this->processNumber = 0;
  this->instanceNumber = 0;
  this->componentNumber = 0;
  }

RTDS_SdlInstanceId::RTDS_SdlInstanceId(int processNumber)
  {
  this->processNumber = processNumber;
  this->instanceNumber = 0;
  this->componentNumber = 0;
  }

RTDS_SdlInstanceId::RTDS_SdlInstanceId(int processNumber, unsigned int instanceNumber, unsigned int componentNumber)
  {
  this->processNumber = processNumber;
  this->instanceNumber = instanceNumber;
  this->componentNumber = componentNumber;
  }

// Copy constructor (reference)
RTDS_SdlInstanceId::RTDS_SdlInstanceId(const RTDS_SdlInstanceId &instance)
  {
  this->processNumber = instance.processNumber;
  this->instanceNumber = instance.instanceNumber;
  this->componentNumber = instance.componentNumber;
  }

// Copy constructor (pointer)
RTDS_SdlInstanceId::RTDS_SdlInstanceId(const RTDS_SdlInstanceId *instance)
  {
  if (instance == NULL)
    {
    this->processNumber = 0;
    this->instanceNumber = 0;
    this->componentNumber = 0;
    }
  else
    {
    this->processNumber = instance->processNumber;
    this->instanceNumber = instance->instanceNumber;
    this->componentNumber = instance->componentNumber;
    }
  }
      
// Assign operator (reference)
RTDS_SdlInstanceId &RTDS_SdlInstanceId::operator=(const RTDS_SdlInstanceId &instance)
  {
  if (this != &instance)
    {
    this->processNumber = instance.processNumber;
    this->instanceNumber = instance.instanceNumber;
    this->componentNumber = instance.componentNumber;
    }
  return *this;
  }

// Assign operator (pointer)
RTDS_SdlInstanceId &RTDS_SdlInstanceId::operator=(const RTDS_SdlInstanceId *instance)
  {
  if (instance == NULL)
    {
    this->processNumber = 0;
    this->instanceNumber = 0;
    this->componentNumber = 0;
    }
  else if (this != instance)
    {
    this->processNumber = instance->processNumber;
    this->instanceNumber = instance->instanceNumber;
    this->componentNumber = instance->componentNumber;
    }
  return *this;
  }

// Equality operator (reference)
bool RTDS_SdlInstanceId::operator==(const RTDS_SdlInstanceId &instance)
  {
  return (this->processNumber == instance.processNumber 
    && this->instanceNumber == instance.instanceNumber 
    && this->componentNumber == instance.componentNumber);
  }

// Equality operator (pointer)
bool RTDS_SdlInstanceId::operator==(const RTDS_SdlInstanceId *instance)
  {
  if (instance == NULL)
    {
    return (this->processNumber == 0 && this->instanceNumber == 0 && this->componentNumber == 0);
    }
  return (this->processNumber == instance->processNumber 
    && this->instanceNumber == instance->instanceNumber 
    && this->componentNumber == instance->componentNumber);
  }
