#include <stdlib.h>
#include <string.h>

#include "RTDS_BinarySemaphoreProcess.h"
#include "RTDS_Common.h"
#include "RTDS_InternalConstants.h"


RTDS_BinarySemaphoreProcess::RTDS_BinarySemaphoreProcess(RTDS_Scheduler *parentScheduler): RTDS_SemaphoreProcess(parentScheduler)
  {
  available = 1;
  }

short RTDS_BinarySemaphoreProcess::isAvailable() 
  {
  return available;
  }

short RTDS_BinarySemaphoreProcess::RTDS_continuousSignals(int *lowestPriority) 
  {
  return 0;
  }

short RTDS_BinarySemaphoreProcess::RTDS_executeTransition(RTDS_MessageHeader* currentMessage) 
  {
  static RTDS_SdlInstanceId waiterId;
  memset(&waiterId, 0, sizeof(RTDS_SdlInstanceId));
  // Remember previous state
  RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  // Remember message as current one
  RTDS_currentContext->currentMessage = currentMessage;
  // Standard double-switch for all other messages
  if (RTDS_currentContext->currentMessage != NULL)
    {
    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch (RTDS_currentContext->currentMessage->messageNumber)
      {
      // Take attempt
      case RTDS_message_RTDS_takeSemaphore:
        // If semaphore is available
        if (available)
          {
          // Make it unavailable
          available = 0;
          // Take succeeded
          RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, RTDS_senderId);
          }
        // If semaphore is not available
        else
          {
          // Add message sender to list of waiting processes
          pushWaitingInstance(RTDS_senderId);
          }
        break;

      // Give
      case RTDS_message_RTDS_giveSemaphore:
        // If semaphore wasn't already available
        if (!available)
          {
          // If there are waiting processes, pop first one from the list
          waiterId = popWaitingInstance();
          if (waiterId.instanceNumber > 0)
            {
            // If found, send message indicating take succeeded for it
            RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, 0, waiterId);
            }
          // If no waiting instances
          else
            {
            // Make semaphore available
            available = 1;
            }
          }
        break;

      // Take cancel
      case RTDS_message_RTDS_cancelTake:
        // Remove message sender from list of instances waiting for semaphore
        removeWaitingInstance(RTDS_senderId);
        break;
      }
      free(RTDS_currentContext->currentMessage);
      RTDS_currentContext->currentMessage = NULL;
    }
  return 0;
  }
