/* ****************************************************************** */
/* $(RTDS_HOME)/share/ccg/FreeRTOS/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS FreeRTOS integration                                */
#ifdef RTDS_FREERTOS_WINDOWS_SIMULATOR
    #ifdef RTDS_SOCKET_PORT
        #include "RTDS_TCP_Client.h"
    #endif

    #ifdef RTDS_CMD_INTERPRETER
        #include "RTDS_CmdInterpreter.h"
    #endif

    #ifdef RTDS_FORMAT_TRACE
        #include "RTDS_FormatTrace.h"
    #endif

    #ifdef RTDS_SOCKET_PORT
     int globalClientSocketId = 0;
    #endif
#endif

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo		*RTDS_globalProcessInfo=NULL;
RTDS_GlobalSemaphoreInfo	*RTDS_globalSemaphoreInfo=NULL;

static int socketEnable = 0;
static RTDS_SOCKET_ID_TYPE clientSocketId=0;

RTDS_COVERAGE_DECL;
RTDS_SYS_TIME_DECL;
RTDS_START_SYNCHRO_DECL;
RTDS_CRITICAL_SECTION_DECL;

#ifdef RTDS_FREERTOS_WINDOWS_SIMULATOR
    /* Macros for traces through socket */
    RTDS_CRITICAL_TRACE_SECTION_DECL;
    RTDS_SOCKET_ACCESS_DECL
    RTDS_DTRACE_ACKNOWLEDGE_DECL;
#endif


/* **************************************************************** *
 *	vApplicationMallocFailedHook
 * **************************************************************** */
void vApplicationMallocFailedHook( void )
{
	/* Can be implemented if required. */
}


/* **************************************************************** *
 *    RTDS_StopProgram
 * **************************************************************** *
 *    Function for stopping program using breakpoint and
 *    command interpreter Client
 * **************************************************************** */
void RTDS_StopProgram( void )
    {
    }

	
/* **************************************************************** *
 *    RTDS_Socket
 * **************************************************************** *
 * Function that reads the socket connected to the model debugger
 * **************************************************************** */
int RTDS_Socket(void)
{
#if RTDS_SOCKET_PORT
    char * currentData;       /* ptr on data to read from socket */
    int currentSize;          /* Data size to read from socket */
#endif    

#ifdef RTDS_CMD_INTERPRETER
    enum RTDS_CmdType              commandId;
    RTDS_UnionCommandParam       * pCommandParam;
    RTDS_CmdSendMsg2ProcNumber   * paramSendMsg2pNumber = NULL;    /* Variable for sending SDL message*/
    RTDS_CmdSendMsg2ProcId       * paramSendMsg2pId = NULL;
    RTDS_SdlInstanceId           * receiverSdlInstanceId;
    RTDS_SdlInstanceId           * senderSdlInstanceId;
    RTDS_GlobalProcessInfo       * processInfoSender;
    RTDS_GlobalProcessInfo       * processInfoReceiver;
    RTDS_CmdForceTimer           * paramForceTimer = NULL;    /* Variable for forcing timer */
    RTDS_CmdTraceConfig          * paramTraceConf = NULL;    /* Variable for configuring trace */
#endif

#if defined( RTDS_SIMULATOR ) && defined( RTDS_CMD_INTERPRETER ) && defined( RTDS_SOCKET_PORT )    
    if ( socketEnable == 1 )
        {
        while( RTDS_ReadSocket( clientSocketId, &currentData, &currentSize, RTDS_CMD_DELIMITERCHAR, RTDS_ESCAPECHAR )!= -1 )
            {
            if ( RTDS_InterpretCommand( currentData, &commandId, &pCommandParam ) != RTDS_ERROR )
                {
                /* Process command */
                switch( commandId )
                    {
                    case ACK_CMDID:
                        RTDS_DTRACE_ACKNOWLEDGE_RECEIVED;
                        break;
                    
                    case STOP_CMDID:
                        /* Suspend tasks otherwise multiple calls to watchdog will raise a sigtrap */
                        vTaskSuspendAll();
						RTDS_GetSystemTime();
                        RTDS_StopProgram();
                        xTaskResumeAll();
                        break;
                    
                    case MSG2PROCID:
                        /* pCommandParam is a valid RTDS_CmdSendMsg2ProcId struct */
                        paramSendMsg2pId = ( RTDS_CmdSendMsg2ProcId * )pCommandParam;
                        /* Check Receiver exists */
                        processInfoReceiver = RTDS_GetProcessInfoFromSdlInstanceId( paramSendMsg2pId->receiver );
                        /* Check Sender exists */
                        processInfoSender = RTDS_GetProcessInfoFromSdlInstanceId( paramSendMsg2pId->sender );
                        
                        /* If receiver or sender are not known */
                        if (processInfoReceiver == NULL)
                            {
                            break;
                            }
                        if (processInfoSender == NULL)
                            senderSdlInstanceId = NULL;
                        else
		                        senderSdlInstanceId = processInfoSender->mySdlInstanceId;

                        receiverSdlInstanceId = processInfoReceiver->mySdlInstanceId;

                        RTDS_SimulatorMsgQueueSend
														(
                            paramSendMsg2pId->messageNumber,
                            paramSendMsg2pId->dataLength,
                            paramSendMsg2pId->pData,
                            receiverSdlInstanceId,
                            senderSdlInstanceId,
                            processInfoSender
                        		);
                        break;
                    
                    case MSG2PROCNUM:
                        /* pCommandParam is a valid RTDS_CmdSendMsg2ProcNumber struct */
                        paramSendMsg2pNumber = ( RTDS_CmdSendMsg2ProcNumber * )pCommandParam;
                        /* Get Sender QueueId*/
                        processInfoSender = RTDS_GetProcessInfoFromProcessNum( paramSendMsg2pNumber->sender );
                        
                        RTDS_SimulatorMsgQueueSend
                        (
                            paramSendMsg2pNumber->messageNumber,
                            paramSendMsg2pNumber->dataLength,
                            paramSendMsg2pNumber->pData,
                            RTDS_GetProcessQueueId( paramSendMsg2pNumber->receiver ),
                            RTDS_GetProcessQueueId( paramSendMsg2pNumber->sender ),
                            processInfoSender
                        );
                        break;
                    
                    case TIMER_CMDID:
                        /* pCommandParam is a valid RTDS_CmdForceTimer struct */
                        paramForceTimer = ( RTDS_CmdForceTimer * )pCommandParam;
                        #ifdef TO_DO
                        RTDS_ForceTimer( paramForceTimer->pId, paramForceTimer->timerNum );
                        #endif
                        break;
                    
                    case SYSCLOCK_CMDID:
                        #ifdef TO_DO
                        RTDS_SetSystemTime( ( long )pCommandParam );
                        #endif
                        break;
                    
                    case TRACE_CMDID:
                    #ifdef RTDS_FORMAT_TRACE
                        paramTraceConf = ( RTDS_CmdTraceConfig * )pCommandParam;
                        RTDS_ConfigureTrace( paramTraceConf );
                    #endif
                        break;
                    
                    default:
                        break;
                    }
                }
            RTDS_FREE( currentData );
            }
        }
#endif    

return 0;

}


/* **************************************************************** *
 *	RTDS_Start
 * **************************************************************** *
 * That is RTDS generated code entry point.
 * This task or function will create all the static processes and
 * semaphores and when everyone is ready will let them go.
 * **************************************************************** *
 * Parameters:
 *	 none
 * Returns:
 *	 nothing
 * **************************************************************** *
 * Context:
 *	 Called by main
 * **************************************************************** */

int RTDS_Start(void)
{
#if defined( RTDS_SIMULATOR ) && defined( RTDS_CMD_INTERPRETER ) && defined( RTDS_SOCKET_PORT )

	RTDS_GlobalProcessInfo *RTDS_currentContext=NULL;
	/* Set up the process context needed to create tasks */
	RTDS_currentContext = (RTDS_GlobalProcessInfo *)RTDS_MALLOC(sizeof(RTDS_GlobalProcessInfo));
	if ( RTDS_currentContext == NULL )
		RTDS_SYSTEM_ERROR(RTDS_ERROR_STARTUP_CONTEXT_MALLOC);
	RTDS_currentContext->sdlProcessNumber = 0;
	RTDS_currentContext->myRtosTaskId = ( RTDS_RtosTaskId )0;
	RTDS_currentContext->sdlState = 0;
	RTDS_currentContext->next = NULL;
	RTDS_currentContext->parentSdlInstanceId = NULL;
	RTDS_currentContext->offspringSdlInstanceId = NULL;
	RTDS_currentContext->currentMessage = NULL;
	RTDS_currentContext->timerList = NULL;
	RTDS_currentContext->mySdlInstanceId = NULL;

	
	/* RTDS_Socket is started in a thread because it handles the socket communication with the SDL-RT debugger */
	/* Task creation */
	if ( xTaskCreate( 
		(pdTASK_CODE) RTDS_Socket, 
		"RTDS_Socket", 
		(unsigned portSHORT) RTDS_TASK_STACK_SIZE, 
		(void *) NULL, 
		(unsigned portBASE_TYPE) RTDS_DEFAULT_PROCESS_PRIORITY, 
		(xTaskHandle *)NULL 
		) != pdPASS  )
			{
			RTDS_SYSTEM_ERROR(RTDS_ERROR_PROCESS_CREATE_TASK_SPAWN);
			}
#endif

/* $(RTDS_HOME)/share/ccg/FreeRTOS/bricks/RTDS_Startup_begin.c ends */
/* **************************************************************** */
