/* ***************************************************************** */
/* $(RTDS_HOME)/share/ccg/embos/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS Embos integration                                */

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo * RTDS_globalProcessInfo = NULL;
RTDS_GlobalSemaphoreInfo * RTDS_globalSemaphoreInfo = NULL;

RTDS_COVERAGE_DECL;
RTDS_CRITICAL_SECTION_DECL;

/* **************************************************************** *
 * RTDS_Start
 * **************************************************************** *
 * That is RTDS generated code entry point.
 * This task or function will create all the static processes and
 * semaphores and when everyone is ready will let them go.
 * **************************************************************** *
 * Parameters:
 *      none
 * Returns:
 *      nothing
 * **************************************************************** */
void RTDS_Start( void )
    {
    RTDS_GlobalProcessInfo * globalProcessInfoTmp = NULL;
    RTDS_GlobalProcessInfo * RTDS_currentContext = NULL;
    
    OS_IncDI();             /* Initially disable interrupts  */
    OS_InitKern();          /* initialize OS */
    OS_InitHW();            /* initialize Hardware for OS */
    
    RTDS_COVERAGE_INIT;
    RTDS_CRITICAL_SECTION_INIT;
    
#ifdef RTDS_SIMULATOR
    /* Set up the message unique id pool */
    RTDS_globalMessageUniqueIdPool = ( unsigned char * )RTDS_MALLOC( RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE );
    {
    int RTDS_i;
    unsigned char * index;
    
    index = RTDS_globalMessageUniqueIdPool;
    for( RTDS_i = 0; RTDS_i < RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE; RTDS_i++ )
        {
        *index = 0x00;
        index++;
        }
    }
#endif
    
#if defined( RTDS_BACK_TRACE_MAX_EVENT_NUM ) && defined( RTDS_SIMULATOR )
    /* Initialize circular buffer to trace in RAM */
    RTDS_TraceInit();
#endif

    /* $(RTDS_HOME)/share/ccg/embos/bricks/RTDS_Startup_begin.c ends */
    /* *************************************************************** */
