#define RTDS_OK          0
#define RTDS_ERROR      -1

/*
 * DEFINE FOR QUEUE MANIPULATION:
 * ------------------------------
 */
#define RTDS_QUEUE_MAX_MSG                  20                              /* Maximum number of messages in a queue */
#define RTDS_QUEUE_MAX_MSG_LENGTH           sizeof( RTDS_MessageHeader )    /* Maximum length of messages in a queue */

/*
 * DEFINE FOR SEMAPHORE MANIPULATION:
 * ------------------------------
 */
#define RTDS_SEMAPHORE_TIME_OUT_FOREVER -1                      /* If we try to take the semaphore without timeout */

#define RTDS_SEMAPHORE_OPTION_FIFO                              /* Not implemented */

#define RTDS_SEMAPHORE_MAX_NAME_LENGTH  20                      /* Maximum length of a semaphore name */

#define RTDS_BINARY_SEM_INITIAL_EMPTY   0                       /* Binary semaphore creation initial state: empty */
#define RTDS_BINARY_SEM_INITIAL_FULL    1                       /* Binary semaphore creation initial state: full */

#define RTDS_MUTEX_SEM_DELETE_SAFE      0                       /* Protects a task that owns the semaphore from unexpected deletion */
#define RTDS_MUTEX_SEM_INVERSION_SAFE   0                       /* Protect the system from priority inversion */

/*
 * DEFINE FOR PROCESS CREATION:
 * ----------------------------
 */
#define RTDS_TASK_OPTIONS_NUMBER        1                       /* Embos default number of task options */
#define RTDS_DEFAULT_PROCESS_PRIORITY   125                     /* If priority not defined in SDL-RT, it will be given this value */

/* ************************************************************************************ *
CRITICAL SECTION MACROS
 * ************************************************************************************ */
#define RTDS_CRITICAL_SECTION_DECL      RTDS_SemaphoreId RTDS_globalSystemSemId;
#define RTDS_CRITICAL_SECTION_PROTO     extern RTDS_SemaphoreId RTDS_globalSystemSemId;
#define RTDS_CRITICAL_SECTION_INIT \
    RTDS_globalSystemSemId = RTDS_Semaphore_Create( NULL, 0, SEM_MUTEX )

#define RTDS_CRITICAL_SECTION_START \
    OS_Use( RTDS_globalSystemSemId->semId.mutex )

#define RTDS_CRITICAL_SECTION_STOP \
    OS_Unuse( RTDS_globalSystemSemId->semId.mutex )

/* ************************************************************************************ *
 * STARTUP SYNCHRONISATION
 * ************************************************************************************ */
#define RTDS_START_SYNCHRO_GO               OS_Start()

/* ************************************************************************************ *
 *COVERAGE INFORMATION
 * ************************************************************************************ *
 * The coverage information is stored in an array of unsigned char. The SDL-RT symbol
 * number is used as an index; the value stored is the number of times the symbol has
 * been executed. It can not exceed 0xFF for each symbol.
 * ************************************************************************************ */
#ifdef RTDS_COVERAGE_NB_SYMBOLS
    #define RTDS_COVERAGE_DECL              unsigned char RTDS_globalCoverage[ RTDS_COVERAGE_NB_SYMBOLS ];
    #define RTDS_COVERAGE_PROTO             extern RTDS_COVERAGE_DECL
    #define RTDS_COVERAGE_INIT \
        { \
        int RTDS_i; \
        for ( RTDS_i = 0; RTDS_i < RTDS_COVERAGE_NB_SYMBOLS; RTDS_i++ ) \
            { \
            RTDS_globalCoverage[ RTDS_i ] = 0; \
            } \
        }
    #define RTDS_COVERAGE_LOG( SYMBOL_NUMBER ) \
        if ( RTDS_globalCoverage[ SYMBOL_NUMBER ] != 0xFF ) \
            { \
            RTDS_globalCoverage[ SYMBOL_NUMBER ]++; \
            }
#else
        #define RTDS_COVERAGE_DECL
        #define RTDS_COVERAGE_PROTO
        #define RTDS_COVERAGE_INIT
#endif


/*
 * DEFINE FOR SIMULATION:
 * ----------------------
 */
#ifdef RTDS_SIMULATOR
    /* Define on how many bytes the messageUniqueId pool will be made of */
    /* 1 means 1 byte means 1*8 bits means 8 possible simultaneous values */
    /* Maximum is 8192 since the id a long type */
    #define RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE        64
    /* Number of levels when formatting message parameters to be printable */
    /* in the SDL-RT debugger */
    #define RTDS_PARAM_CODEC_MAX_DEPTH              4
    /* Min size of memory chunk used when formatting message parameters */
    /* to be printable in the SDL-RT debugger */
    #define RTDS_PARAM_CODEC_CHUNK_SIZE             128
#endif

/*
 * TYPE RTDS_QUEUE.ID:
 * ----------------------
 * Type for a message queue identifier
 */
typedef OS_Q * RTDS_RtosQueueId;

/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 */
typedef enum{ SEM_COUNTING, SEM_BINARY, SEM_MUTEX }RTDS_SemaphoreType;

typedef union SemType
    {
    OS_CSEMA * semaphore;        /* Semaphore type */
    OS_RSEMA * mutex;                /* mutex type*/
    }SemType;

typedef struct RTDS_SemType
    {
    RTDS_SemaphoreType typeName;
    SemType semId;
    }RTDS_SemType;

typedef RTDS_SemType * RTDS_SemaphoreId;

/*
 * TYPE RTDS_PROCESS_ID:
 * ----------------------
 * Type for a pid
 */
typedef OS_TASK * RTDS_RtosTaskId;

/*
 * TYPE RTDS_TIMER_ID:
 * ----------------------
 * Type for a timer identifier
 */
typedef OS_TIMER RTDS_TimerId;

/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef int RTDS_SemaphoreStatus;

/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef int RTDS_SemaphoreTimeout;

/*
 * TYPE RTDS_PROCESS_PRIORITY:
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;

/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */
#define RTDS_TIMER_OK           1
#define RTDS_TIMER_CANCELLED    0

typedef struct RTDS_TimerState
    {
    RTDS_TimerId watchDogId;
    struct RTDS_MessageHeader * watchDogParam;
    long timerNumber;                           /* Message number for the timer name */
    long timerUniqueId;                         /* Timer's unique identifier among all timers */
    unsigned long timeoutValue;                 /* System tick counter value when it will go off */
    struct RTDS_SdlInstanceId * receiverId;     /* The instance id of the receiver */
    int state;                                  /* State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
    struct RTDS_TimerState * next;              /* Next timer in list */
    } RTDS_TimerState;

/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 */
typedef struct RTDS_GlobalSemaphoreInfo
    {
    RTDS_SemaphoreId semaphoreId;           /* The semaphore address */
    int semaphoreNumber;                    /* Semaphore number representing its name */
    struct RTDS_GlobalSemaphoreInfo * next; /* Next semaphoreInfo */
    } RTDS_GlobalSemaphoreInfo;

RTDS_COVERAGE_PROTO;
RTDS_CRITICAL_SECTION_PROTO;

/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS

/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
    int priority; void * queueArea; struct mappingOfTableOfStack * my_MappingPtr;

