#ifndef _RTDS_INSTANCE_MANAGER_H_
#define _RTDS_INSTANCE_MANAGER_H_

#include <stdlib.h>

#include "RTDS_Proc.h"
#include "RTDS_Scheduler.h"


/*
** TYPE InstanceCreationFunction:
** ------------------------------
** Type for a function creating an instance of a sub-class of RTDS_Proc
*/

typedef RTDS_Proc * (*InstanceCreationFunction)(RTDS_Scheduler*);


/*
** TYPE RTDS_InstanceManagerList:
** ------------------------------
** Type for a list of InstanceManager objects, used by the class to record its own instances
*/

class RTDS_InstanceManager;

typedef struct _RTDS_InstanceManagerList
{
  int                                 processNumber;  // Identifier for the process name; unique in chained list
  RTDS_InstanceManager              * manager;        // Manager for this process name
  struct _RTDS_InstanceManagerList  * next;           // Next item in chained list
} RTDS_InstanceManagerList;


/*
** CLASS RTDS_InstanceManager:
** ===========================
** Instances of this class create instances a process. The class itself registers
** all its instances, allowing to create any process instance.
*/

class RTDS_InstanceManager
{
  /*
  ** ATTRIBUTES:
  */
  
  private:
  
    static  RTDS_InstanceManagerList  * instanceList; // Class attribute recording all instances
    
    InstanceCreationFunction  creationFunction;       // Function actually creating an instance of the managed process
  
  /*
  ** OPERATIONS:
  */
  
  public:
  
    /*
    ** CONSTRUCTOR:
    ** ------------
    ** Associates a process number to the function creating instances of this process
    ** - processNumber: Identifier for the process "name"
    ** - creationFunction: Function creating an instance of this process
    */
    RTDS_InstanceManager(int processNumber, InstanceCreationFunction creationFunction);
    
    /*
    ** CLASS OPERATION createInstance:
    ** -------------------------------
    ** Actually creates an instance of a given process
    ** - parentScheduler: Parent scheduler for process
    ** - processNumber: Identifier for the process "name" for the instance to create
    ** Returns: The object for the created instance
    */
    static RTDS_Proc * createInstance(RTDS_Scheduler * parentScheduler, int processNumber);
};

#endif
