/* ************************************************************* */
/* $(RTDS_HOME)/share/ccg/cmx/bricks/RTDS_Startup_begin.c begins */
/* PragmaDev RTDS CMX integration                                */

/* Pointers to global list of information on processes and semaphores */
RTDS_GlobalProcessInfo		*RTDS_globalProcessInfo=NULL;
RTDS_GlobalSemaphoreInfo	*RTDS_globalSemaphoreInfo=NULL;
/* New timer handling stuff */
void *RTDS_globalTimerEvent[C_MAX_CYCLIC_TIMERS];  /* Array of timer headers, index is the event number */

RTDS_COVERAGE_DECL
RTDS_START_SYNCHRO_DECL
RTDS_CRITICAL_SECTION_DECL


/* **************************************************************** *
 *	RTDS_Start
 * **************************************************************** *
 * That is RTDS generated code entry point.
 * This task or function will create all the static processes and
 * semaphores and when everyone is ready will let them go.
 * **************************************************************** *
 * Parameters:
 *	 none
 * Returns:
 *	 nothing
 * **************************************************************** *
 * Context:
 *	 Called by main
 * **************************************************************** */

int RTDS_Start(void)
{
RTDS_GlobalProcessInfo *RTDS_currentContext=NULL;
int RTDS_i;

RTDS_COVERAGE_INIT;

/* Initialize CMX kernel */
K_OS_Init();

/* Initialize dynamic semaphore id allocation mechanism */
RTDS_initResourceId();

for (RTDS_i=0;RTDS_i<C_MAX_CYCLIC_TIMERS;RTDS_i++)
	RTDS_globalTimerEvent[RTDS_i] 	= NULL;

#ifdef RTDS_SIMULATOR
/* Set up the message unique id pool */
RTDS_globalMessageUniqueIdPool = (unsigned char *)RTDS_MALLOC(RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE);
	{
	unsigned char *RTDS_index;

	RTDS_index = RTDS_globalMessageUniqueIdPool;
	for(RTDS_i=0;RTDS_i<RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE;RTDS_i++)
		{
		*RTDS_index=0x00;
		RTDS_index++;
		}
	}
#endif

#if defined(RTDS_SIMULATOR) && defined(RTDS_BACK_TRACE_MAX_EVENT_NUM)
/* Initialize circular buffer to trace in RAM */
RTDS_TraceInit();
#endif

RTDS_CRITICAL_SECTION_INIT;
RTDS_START_SYNCHRO_INIT;

/* $(RTDS_HOME)/share/ccg/cmx/bricks/RTDS_Startup_begin.c ends */
/* *********************************************************** */
