#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "RTDS-AllMessages.h"


typedef struct ByteStream
  {
  unsigned char * buffer;
  unsigned        size;
  } ByteStream;
  
  
static int write_to_buffer(const void * buffer, size_t expected_size, void * data)
  {
  ByteStream  * b = (ByteStream*)data;
  unsigned      current_index;
  
  if ( b->buffer == NULL )
    {
    current_index = 0;
    b->buffer = malloc(expected_size);
    b->size = expected_size;
    }
  else
    {
    current_index = b->size;
    b->buffer = realloc(b->buffer, b->size + expected_size);
    b->size += expected_size;
    }
  memcpy(&(b->buffer[current_index]), buffer, expected_size);
  
  return 0;
  }


void usage(char * command_name)
  {
  printf("Usage:\n");
  printf("%s b -> generates the hex string for a 'begin_line' message\n", command_name);
  printf("%s e -> generates the hex string for an 'end_line' message\n", command_name);
  printf("%s p x y [-|tag1,tag2,tag3,...] [name] -> generates the hex string for an 'add_point' message at coords x, y, with the specified tags and the specified name if present.\n", command_name);
  printf("%s c x y -> generates the hex string for an 'add_point_by_coords' message at coords x, y.\n", command_name);
  exit(1);
  }
  
  
int main(int argc, char * argv[])
  {
  RTDS_AllMessages_t  * msg;
  char                * tag_start;
  char                * tag_current;
  TagType_t           * tag;
  ByteStream            b;
  asn_enc_rval_t        encode_status;
  int                 i;
  
  if ( argc < 2 ) usage(argv[0]);
  
  msg = calloc(1, sizeof(RTDS_AllMessages_t));
  switch ( argv[1][0] )
    {
    case 'b':
      if ( argc != 2 ) usage(argv[0]);
      msg->present = RTDS_AllMessages_PR_begin_line;
      break;
    
    case 'e':
      if ( argc != 2 ) usage(argv[0]);
      msg->present = RTDS_AllMessages_PR_end_line;
      break;
    
    case 'p':
      if ( (argc != 5) && (argc != 6) ) usage(argv[0]);
      msg->present = RTDS_AllMessages_PR_add_point;
      msg->choice.add_point.param1.x = atoi(argv[2]);
      msg->choice.add_point.param1.y = atoi(argv[3]);
      if ( (argv[4][0] != '-') || (argv[4][1] != '\0') )
        {
        tag_current = strdup(argv[4]);
        while ((tag_start = strsep(&tag_current, ",")) != NULL)
          {
          tag = calloc(1, sizeof(TagType_t));
          OCTET_STRING_fromString(tag, tag_start);
          asn_set_add(&(msg->choice.add_point.param1.tags), tag);
          }
        }
      if ( argc == 6 )
        {
        msg->choice.add_point.param1.name = calloc(1, sizeof(NameType_t));
        OCTET_STRING_fromString(msg->choice.add_point.param1.name, argv[5]);
        }
      break;
    
    case 'c':
      if ( argc != 4 ) usage(argv[0]);
      msg->present = RTDS_AllMessages_PR_add_point_by_coords;
      msg->choice.add_point_by_coords.param1 = atoi(argv[2]);
      msg->choice.add_point_by_coords.param2 = atoi(argv[3]);
      break;
    
    default:
      usage(argv[0]);
    }
    
  b.buffer = NULL;
  b.size = 0;
  encode_status = der_encode(&asn_DEF_RTDS_AllMessages, msg, write_to_buffer, (void*)&b);
  if ( encode_status.encoded == -1 )
    {
    printf("Error! DER encoding failed for type %s\n", encode_status.failed_type->name);
    return 5;
    }
  free(msg);

  for ( i = 0; i < b.size; i++ )
    printf("%02X", b.buffer[i]);
  printf("\n");
  
  return 0;
  }
