#include "PhoneNumberFactory.h"


/*
 * ATTRIBUTES FOR CLASS:
 * ---------------------
 *
 * [From PhoneNumberFactory]
 * - short      numPhone;
 * - RTDS_PID * phoneList;
 */


// PUBLIC OPERATIONS:
// ==================


// Operation PhoneNumberFactory:
// -----------------------------

PhoneNumberFactory::PhoneNumberFactory(short maxPhone)
	{
  numPhone = 0;
  phoneList = (RTDS_PID *)RTDS_MALLOC(maxPhone * sizeof(RTDS_PID));
	}

// Operation append:
// -----------------

short PhoneNumberFactory::append(RTDS_PID pid)
	{
  phoneList[numPhone] = pid;
  numPhone++;
  return (numPhone-1);
	}

// Operation getPid:
// -----------------

RTDS_PID PhoneNumberFactory::getPid(short phoneNum)
	{
  return phoneList[phoneNum];
	}

