#define DEVPATH_I2C     "/dev/i2c-1"  // the device file
#define I2C_SLAVE       0x0703        // ioctl:  Use this slave address

/* Notes on Raspberry Pi sense-hat use
CS_A/G and CS_M (pins 7 and 8) are high: I2C interface is used, with GPIO3 to
SCL/SPC (pin 2) and GPIO2 to SDA/SDI/SDO (pin 4). DRDY_M (pin 9) goes only to
a testpoint. SDO_A/G and SDO_M (pins 5 and 6) are low: device addresses are
0x6a and 0x1c. Pin 13 (DEN_A/G, accelerometer and gyroscope data enable) is to
3V3 thru 10K, but datasheet has no info on this. The INT1_A/G, INT2_A/G and
INT_M pins are wired to MCU port A.
*/

#define LSM9DS1_AG_SAD      0x6a  // slave address for accelerometer/gyroscope 
#define LSM9DS1_AG_WHO_AM_I 0x0f  // read this to get--
#define LSM9DS1_AG_who_am_i 0x68  // accel/gyro device identifier

#define LSM9DS1_AG_STATUS_REG   0x17

#define LSM9DS1_AG_OUT_X_XL_L   0x28  // lin accel sensor X-axis lsb
#define LSM9DS1_AG_OUT_X_XL_H   0x29  // lin accel sensor Y-axis msb
#define LSM9DS1_AG_OUT_Y_XL_L   0x2a  // lin accel sensor Y-axis lsb
#define LSM9DS1_AG_OUT_Y_XL_H   0x2b  // lin accel sensor Y-axis msb
#define LSM9DS1_AG_OUT_Z_XL_L   0x2c  // lin accel sensor Z-axis lsb
#define LSM9DS1_AG_OUT_Z_XL_H   0x2d  // lin accel sensor Z-axis msb

#define LSM9DS1_AG_CTRL_REG1               0x10     // angular rate sensor control reg 1
#define LSM9DS1_AG_CTRL_REG1_ODR_G_if(f)   ((f)<<5) // 3b gyro output data rate
#define LSM9DS1_AG_CTRL_REG1_FS_G_if(f)    ((f)<<3) // 2b gyro full-scale select
#define LSM9DS1_AG_CTRL_REG1_BW_G_if(f)    (f)      // 2b gyro bandwidth select

#define LSM9DS1_AG_CTRL_REG3               0x12     // angular rate sensor control reg 3
#define LSM9DS1_AG_CTRL_REG3_LP_mode_if(f) ((f)<<7) // 1b low power mode enable
#define LSM9DS1_AG_CTRL_REG3_HP_EN_if(f)   ((f)<<6) // 1b high-pass filter enable
#define LSM9DS1_AG_CTRL_REG3_HPCF_G_if(f)  (f)      // 4b gyro high cutoff freq sel

#define LSM9DS1_AG_CTRL_REG6_XL            0x20            // linear accel sensor control reg 6
#define LSM9DS1_AG_CTRL_REG6_XL_ODR_XL_if(f) ((f)<<5)      // 3b out data rate, power
#define LSM9DS1_AG_CTRL_REG6_XL_FS_XL_if(f)  ((f)<<3)      // 2b accel full-scale sel
#define LSM9DS1_AG_CTRL_REG6_XL_BW_SCAL_ODR_if(f) ((f)<<2) // 1b bandwidth sel
#define LSM9DS1_AG_CTRL_REG6_XL_BW_XL_if(f)  (f)           // 2b anti-alias filter bw sel

#define LSM9DS1_AG_CTRL_REG7_XL            0x21     // lin accel sensor control reg 7
#define LSM9DS1_AG_CTRL_REG7_XL_HR_pf(f)   ((f)<<7) // 1b hi res mode enable
#define LSM9DS1_AG_CTRL_REG7_XL_DCF_if(f)  ((f)<<5) // 2b filter cutoff freq sel
#define LSM9DS1_AG_CTRL_REG7_XL_FDS_if(f)  ((f)<<2) // 1b filtered data sel
#define LSM9DS1_AG_CTRL_REG7_XL_HPIS1_if(f) (f)     // 1b hi-pass filter int.en.

#define LSM9DS1_AG_CTRL_REG8               0x22     // control register 8
#define LSM9DS1_AG_CTRL_REG8_BOOT_if(f)   ((f)<<7)  // reboot memory content

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <poll.h>
#include <dirent.h>
#include <string.h>

#include <sys/mman.h>
#include <sys/ioctl.h>

#include <linux/input.h>
#include <linux/fb.h>

extern void i2c_write(int i2c, unsigned char reg1, unsigned char reg2, int size);
extern unsigned char i2c_read(int i2c, unsigned char reg1 );
extern int initLSM9DS1(void);
extern int is_event_device(const struct dirent *dir);
extern int is_framebuffer_device(const struct dirent *dir);
extern int open_evdev(const char *dev_name);
extern int open_fbdev(const char *dev_name);
extern uint16_t Convert24RGBTo16RGB(unsigned int rgb24);


