#ifndef _SERVER_COMMUNICATION_H_
#define _SERVER_COMMUNICATION_H_

#include <stdio.h>
#include <stdlib.h>

#include "portable_sockets.h"

/*
** FUNCTION init_socket:
** ---------------------
** Makes sure the socket is connected to the client.
** Returns: The identifier for the connected socket.
*/
int init_socket(void);

/*
** FUNCTION send_to_client:
** ------------------------
** Sends a message to the client through the socket.
** Parameters:
**  - message_number: Numerical identifier for the sent message, as defined in RTDS_gen.h
**  - data_length: Length for the buffer containg the message parameters
**  - data_pointer: Pointer on the buffer containg the message parameters
*/
void send_to_client(int message_number, unsigned data_length, void * data_pointer);

/*
** MACRO SEND_TO_CLIENT:
** ---------------------
** Macro used in TO_ENV clause when sending a message to the distant client
** Parameters:
**  - MESSAGE_NUMBER: Numerical identifier for the sent message, as defined in RTDS_gen.h
**  - DATA_LENGTH: Length for the buffer containg the message parameters
**  - DATA_POINTER: Pointer on the buffer containg the message parameters
** These parameters are filled automatically by the generated code for the message output symbol.
** The sending itself is protected via a semaphore, since the variable containing the socket connected
** to the distant client is global.
*/
#define SEND_TO_CLIENT(MESSAGE_NUMBER, DATA_LENGTH, DATA_POINTER) \
  RTDS_SEMAPHORE_NAME_TAKE("socket_access", socket_access, RTDS_SEMAPHORE_TIME_OUT_FOREVER); \
  send_to_client(MESSAGE_NUMBER, DATA_LENGTH, DATA_POINTER); \
  RTDS_SEMAPHORE_NAME_GIVE("socket_access", socket_access);

#endif
