#ifndef _SERVER_COMMUNICATION_H_
#define _SERVER_COMMUNICATION_H_

#include <stdio.h>
#include <stdlib.h>

#include "portable_sockets.h"


/*
** FUNTION init_socket:
** --------------------
** Initializes the socket connection if needed.
** Returns: The identifier for the socket connected to the distant server.
*/
int init_socket(void);


/*
** FUNCTION send_to_server:
** ------------------------
** Actually sends a message to the distant server
** Parameters:
**  - message_number: Generated identifier for the message to send, as defined in RTDS_gen.h
**  - data_length: Length of the buffer for message parameters
**  - data_pointer: Pointer on the buffer for message parameters
*/
void send_to_server(int message_number, unsigned data_length, void * data_pointer);


/*
** MACRO SEND_TO_SERVER:
** ---------------------
** Macro used in TO_ENV clause when sending a message to the distant server
** Parameters:
**  - MESSAGE_NUMBER: Generated identifier for the message to send, as defined in RTDS_gen.h
**  - DATA_LENGTH: Length of the buffer for message parameters
**  - DATA_POINTER: Pointer on the buffer for message parameters
** These parameters are filled automatically by the generated code for the message output symbol.
** The sending itself is protected via a semaphore, since the variable containing the socket connected
** to the distant server is global.
*/
#define SEND_TO_SERVER(MESSAGE_NUMBER, DATA_LENGTH, DATA_POINTER) \
  RTDS_SEMAPHORE_NAME_TAKE("socket_access", socket_access, RTDS_SEMAPHORE_TIME_OUT_FOREVER); \
  send_to_server(MESSAGE_NUMBER, DATA_LENGTH, DATA_POINTER); \
  RTDS_SEMAPHORE_NAME_GIVE("socket_access", socket_access);

#endif
