from Tkinter import *
from threading import Thread
from socket import *
import signal
import os


## CLASS GENERIC.CALLBACK:
## =======================
# Generic class to be able to call the same function from any button
class GenericCallback:
	def __init__(self,callback,*firstArgs):
		self.__callback = callback
		self.__firstArgs = firstArgs
		
	def __call__(self,*lastArgs):
		apply(self.__callback, self.__firstArgs+lastArgs)



## CLASS ACS.RECEIVING.STATE:
## =======================
# List internal receiving state to treat incoming messages
class AcsReceivingState:
	IDLE								= "IDLE"
	WAITING_PARAMETERS	= "WAITING_PARAMETERS"
	MESSAGE_RECEIVED		= "MESSAGE_RECEIVED"



## CLASS ACS.GUI
## =======================
# Main class of the GUI
class AcsGui(Tk):
	def __init__(self):
		# init of TopLevel has to be called.
		Tk.__init__(self)
		self.mainFrame = Frame(self)
		self.mainFrame.pack()

		# To store generic events
		self.__genericEventList = []

		# To handle socket connected to the simulator
		self.__simulatorSocket = None

		# Internal receiving state
		self.__receivingState = AcsReceivingState.IDLE

		# Display
		self.__display = Label(self.mainFrame, relief="sunken", bg="white")
		#self.__displayContent = StringVar()
		#self.__display.config(textvariable=self.__displayContent)
		self.__display.grid (row=0,columnspan=3,sticky=EW)
		
		# Keys
		Button(self.mainFrame,text= '1',width=8,command=GenericCallback(self.keyPress,'1')).grid (row=1,column=0)
		Button(self.mainFrame,text= '2',width=8,command=GenericCallback(self.keyPress,'2')).grid (row=1,column=1)
		Button(self.mainFrame,text= '3',width=8,command=GenericCallback(self.keyPress,'3')).grid (row=1,column=2)
		Button(self.mainFrame,text= '4',width=8,command=GenericCallback(self.keyPress,'4')).grid (row=2,column=0)
		Button(self.mainFrame,text= '5',width=8,command=GenericCallback(self.keyPress,'5')).grid (row=2,column=1)
		Button(self.mainFrame,text= '6',width=8,command=GenericCallback(self.keyPress,'6')).grid (row=2,column=2)
		Button(self.mainFrame,text= '7',width=8,command=GenericCallback(self.keyPress,'7')).grid (row=3,column=0)
		Button(self.mainFrame,text= '8',width=8,command=GenericCallback(self.keyPress,'8')).grid (row=3,column=1)
		Button(self.mainFrame,text= '9',width=8,command=GenericCallback(self.keyPress,'9')).grid (row=3,column=2)
		Button(self.mainFrame,text= '*',width=8,command=GenericCallback(self.keyPress,'*')).grid (row=4,column=0)
		Button(self.mainFrame,text= '0',width=8,command=GenericCallback(self.keyPress,'0')).grid (row=4,column=1)
		Button(self.mainFrame,text= '#',width=8,command=GenericCallback(self.keyPress,'#')).grid (row=4,column=2)

		# Put a separator: line
		Frame(self.mainFrame,height=2,relief=SUNKEN,borderwidth=1).grid(row=5, columnspan=3, pady=5, sticky=NSEW)
		
		# Cards
		Button(self.mainFrame,text= 'Supervisor card',command=self.insertCardSupervisor).grid(row=6,columnspan=3,sticky=EW)
		Button(self.mainFrame,text= 'User 1 card',command=self.insertCardUser1).grid(row=7,columnspan=3,sticky=EW)
		Button(self.mainFrame,text= 'User 2 card',command=self.insertCardUser2).grid(row=8,columnspan=3,sticky=EW)
		
		# Put a separator: line
		Frame(self.mainFrame,height=2,relief=SUNKEN,borderwidth=1).grid(row=9, columnspan=3, pady=5, sticky=NSEW)
		
		# Socket port value
		self.__socketEntry = Entry(self.mainFrame)
		self.__socketPortNumber = StringVar()
		self.__socketEntry.config(textvariable=self.__socketPortNumber)
		self.__socketEntry.grid (row=10,columnspan=3,sticky=EW)
		
		# Keys
		Button(self.mainFrame,text= 'connect', command=self.connectSimulator, width=8).grid (row=11,column=0)
		Button(self.mainFrame,text= 'disconnect', command=self.disconnectSimulator, width=8).grid (row=11,column=2)

		self.__socketState = IntVar()
		Radiobutton(self.mainFrame, text="Up", state=DISABLED, variable=self.__socketState, value=0).grid (row=12,column=0)
		Radiobutton(self.mainFrame, text="Down", state=DISABLED, variable=self.__socketState, value=1).grid (row=12,column=1)
		Radiobutton(self.mainFrame, text="Error", state=DISABLED, variable=self.__socketState, value=2).grid (row=12,column=2)
		self.__socketState.set(1)
				
		self.bind("<<getNextGenericEvent>>",self.getNextGenericEvent)
		if sys.platform.startswith('sol'):
			signal.signal(signal.SIGUSR1, self.postGenericEvent)

		self.title("Access control")
		self.mainloop()

	def genericCallBack(self):
		if not sys.platform.startswith('sol'):
			self.event_generate('<<getNextGenericEvent>>',when='head')
		else:
			os.kill(os.getpid(),signal.SIGUSR1)

	def postGenericEvent(self, signum=None, frame=None):
		self.event_generate('<<getNextGenericEvent>>',when='head')




	## -------------------------
	## METHOD GENERIC.EVENT.RECEIVED:
	## -------------------------
	# Operation called when an event has been asynchronously received (simulatorThread). It stores what has been received in a list.
	# The event will be retrieved by the main thread with the getNextGenericEvent operation.
	## -------------------------
	# Parameters:
	# - messageToDisplay (string) message to be displayed

	def genericEventReceived(self, messageToDisplay):
		# Store message in a list
		self.__genericEventList.append(messageToDisplay)



	## -------------------------
	## METHOD GET.NEXT.GENERIC.EVENT:
	## -------------------------
	# Operation called to treat the next event stored in the list by genericEventReceived operation.
	# All this to do main of the treatment in the main thread instead of simulatorThread.
	## -------------------------
	# Parameters:
	# - None

	def getNextGenericEvent(self, signum=None, frame=None):
		if len(self.__genericEventList)!= 0:
			messageToDisplay = self.__genericEventList[0]
			self.__genericEventList = self.__genericEventList[1:]
			self.__display.configure(text=messageToDisplay)



	## Connects to the simulator
	def connectSimulator(self):
		if self.__simulatorSocket != None:
			return
		try:
			self.__simulatorSocket = socket(AF_INET, SOCK_STREAM)
			portNumber = self.__socketPortNumber.get()
			if portNumber.isdigit():
				self.__simulatorSocket.connect((gethostname(), long(portNumber)))
			else:
				self.__socketState.set(2)
				return

		except error, socketError :
			print "connectSimulator: socketError: %s" %socketError			
			self.__socketState.set(2)
			return
		
		self.__socketState.set(0)
		# Start a thread that hangs on a socket
		simThread = Thread(None, self.simulatorThread)
		simThread.setDaemon(1)
		simThread.start()


	def keyPress(self,key):
		if self.__simulatorSocket != None:
			self.__simulatorSocket.send("send2name RTDS_Env pLocal mKey |{param1|="+key+"|}\n")


	def insertCardSupervisor(self):
		if self.__simulatorSocket != None:
			self.__simulatorSocket.send("send2name RTDS_Env pLocal mCard |{param1|=|:PragmaCard|}\n")


	def insertCardUser1(self):
		if self.__simulatorSocket != None:
			self.__simulatorSocket.send("send2name RTDS_Env pLocal mCard |{param1|=|:aCard|}\n")


	def insertCardUser2(self):
		if self.__simulatorSocket != None:
			self.__simulatorSocket.send("send2name RTDS_Env pLocal mCard |{param1|=|:anotherCard|}\n")


	def disconnectSimulator(self):
		if self.__simulatorSocket == None:
			return
		self.__socketState.set(1)
		self.__simulatorSocket.close()
		self.__simulatorSocket = None


	## METHOD SIMULATOR.THREAD:
	## -----------------------------
	## Purpose: Thread that reads the socket connected to the simulator.
	## -----------------------------
	# Parameters:
	# - nothing
	# Returns:
	# - nothing

	def simulatorThread(self):

		#self.__externalToolConnection, addr = self.__simulatorSocket.accept()
		#print "Thread started"
		# Hang on the socket waiting for an external tool to write on it
		externalCommand = ''
		try:
			while 1:
				if self.__simulatorSocket == None :
					return
				data = self.__simulatorSocket.recv(1)
				if data == '\n':
					#print "simulatorThread: completed externalCommand: ", externalCommand
					self.simulatorInterpretor(externalCommand)
					externalCommand = ''
				else:
					#print "Simulator: externalToolThread: externalCommand: ", externalCommand
					externalCommand = externalCommand + data
		except error, socketError :
			#print "simulatorThread: socketError: %s" %socketError
			self.__socketState.set(2)
			self.__simulatorSocket = None


	def simulatorInterpretor(self, simulatorMsg):
		if self.__receivingState == AcsReceivingState.IDLE :
			if simulatorMsg.startswith('Message') and simulatorMsg.find('received by') != -1 and	simulatorMsg.find('RTDS_Env') != -1 :
				fields = simulatorMsg.split()
				self.__receivedMessage = fields[1]
				self.__receivingState = AcsReceivingState.MESSAGE_RECEIVED
				#print "AcsGui: simulatorInterpretor: Message %s received" % self.__receivedMessage
		elif self.__receivingState == AcsReceivingState.MESSAGE_RECEIVED :
			if simulatorMsg.startswith('{param1='):
				self.__receivedMessageParameter = simulatorMsg[simulatorMsg.find(':')+1:][:-1]
				self.genericEventReceived(self.__receivedMessageParameter)
				self.genericCallBack()
				self.__receivingState = AcsReceivingState.IDLE
			elif simulatorMsg.startswith('Message') and simulatorMsg.find('received by') != -1 and	simulatorMsg.find('RTDS_Env') != -1 :
				fields = simulatorMsg.split()
				self.__receivedMessage = fields[1]
				#print "AcsGui: simulatorInterpretor: Waiting for message parameters"
			else:
				self.__receivingState = AcsReceivingState.IDLE




# main
app = AcsGui()
app.mainloop()
