/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx.verification;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.fxmisc.richtext.CodeArea;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.fx.IAppContext;

public class ErrorsView
extends TableView<Throwable> {
    protected final IAppContext context;

    public ErrorsView(IAppContext context, ObservableList<Throwable> errors) {
        this.context = context;
        TableColumn iconColumn = new TableColumn("");
        iconColumn.setCellValueFactory(c -> new SimpleObjectProperty(c.getValue()));
        iconColumn.setCellFactory(c -> new IconCell());
        iconColumn.setPrefWidth(25.0);
        this.getColumns().add((Object)iconColumn);
        TableColumn typeColumn = new TableColumn("Type");
        typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("class"));
        typeColumn.setCellFactory(c -> new ErrorCell());
        typeColumn.setPrefWidth(110.0);
        this.getColumns().add((Object)typeColumn);
        TableColumn messageColumn = new TableColumn("Message");
        messageColumn.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        messageColumn.setCellFactory(c -> new MessageCell());
        messageColumn.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)typeColumn.widthProperty()).subtract((ObservableNumberValue)iconColumn.widthProperty()));
        this.getColumns().add((Object)messageColumn);
        this.setItems(errors);
    }

    public void resize(double width, double height) {
        super.resize(width, height);
        Pane header = (Pane)this.lookup("TableHeaderRow");
        header.setPrefHeight(15.0);
    }

    public class MessageCell
    extends TableCell<Throwable, String> {
        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setGraphic(null);
            if (empty || item == null) {
                this.setText(null);
            } else {
                String text = item.replaceAll("\\[.*Exception\\] *", "");
                this.setText(text);
            }
        }
    }

    public class ErrorCell
    extends TableCell<Throwable, Class> {
        protected void updateItem(Class item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setGraphic(null);
            if (empty || item == null) {
                this.setText(null);
            } else {
                String simpleName = item.getSimpleName();
                simpleName = simpleName.replaceAll("[Ee]xception", "");
                this.setText(simpleName);
            }
        }
    }

    public class IconCell
    extends TableCell<Throwable, Throwable> {
        protected final FontIcon icon = new FontIcon("gmi-error:20:red");

        public IconCell() {
            this.icon.setOnMouseClicked(event -> {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream));
                ((Throwable)this.getItem()).printStackTrace(writer);
                writer.close();
                CodeArea code = new CodeArea(new String(stream.toByteArray(), StandardCharsets.UTF_8));
                code.setEditable(false);
                ErrorsView.this.context.openView("Error " + ((Throwable)this.getItem()).getMessage(), (Region)code);
            });
        }

        protected void updateItem(Throwable item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            if (empty) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.icon);
            }
        }
    }
}

