/*
 * Decompiled with CFR 0.152.
 */
package plug.code_editor.richtextfx;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class FiacreStyler {
    private static final String[] KEYWORDS = new String[]{"and", "any", "append", "array", "assert", "begin", "bool", "case", "channel", "component", "const", "dequeue", "do", "else", "elsif", "empty", "end", "enqueue", "extern", "false", "first", "foreach", "from", "full", "function", "if", "in", "init", "int", "is", "length", "loop", "nat", "none", "not", "null", "of", "on", "or", "out", "par", "port", "priority", "process", "property", "queue", "read", "record", "return", "select", "states", "sync", "then", "to", "true", "type", "union", "unless", "var", "wait", "where", "while", "write"};
    private static final String KEYWORD_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS) + ")\\b";
    private static final String PAREN_PATTERN = "\\(|\\)";
    private static final String BRACE_PATTERN = "\\{|\\}";
    private static final String BRACKET_PATTERN = "\\[|\\]";
    private static final String SEMICOLON_PATTERN = "\\;";
    private static final String STRING_PATTERN = "\"([^\"\\\\]|\\\\.)*\"";
    private static final String COMMENT_PATTERN = "//[^\n]*|/\\*(.|\\R)*?\\*/";
    private static final Pattern PATTERN = Pattern.compile("(?<KEYWORD>" + KEYWORD_PATTERN + ")|(?<PAREN>" + "\\(|\\)" + ")|(?<BRACE>" + "\\{|\\}" + ")|(?<BRACKET>" + "\\[|\\]" + ")|(?<SEMICOLON>" + "\\;" + ")|(?<STRING>" + "\"([^\"\\\\]|\\\\.)*\"" + ")|(?<COMMENT>" + "//[^\n]*|/\\*(.|\\R)*?\\*/" + ")");

    public StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("KEYWORD") != null ? "keyword" : (matcher.group("PAREN") != null ? "paren" : (matcher.group("BRACE") != null ? "brace" : (matcher.group("BRACKET") != null ? "bracket" : (matcher.group("SEMICOLON") != null ? "semicolon" : (matcher.group("STRING") != null ? "string" : (styleClass = matcher.group("COMMENT") != null ? "comment" : null))))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }
}

