/*
 * Decompiled with CFR 0.152.
 */
package properties.LTL.ltl3ba;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class LTL3BA {
    private static final Path ltl3bPath;

    private List<String[]> ltl3ba(String formula) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ltl3bPath.toString());
        command.add("-T3");
        command.add("-f");
        command.add(formula);
        try {
            Process process = new ProcessBuilder(command).start();
            List<String[]> transitions = this.processResult(process.getInputStream());
            return transitions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    List<String[]> processResult(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        br.readLine();
        ArrayList<String[]> transitions = new ArrayList<String[]>();
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(",|;");
            String guard = parts[2].trim().replaceAll("\"$|^\"", "");
            if (guard.equals("(1)")) {
                guard = "true";
            }
            transitions.add(new String[]{parts[0].trim(), parts[1].trim(), guard});
        }
        br.close();
        return transitions;
    }

    public static List<String[]> transform(String formula) {
        LTL3BA tr = new LTL3BA();
        return tr.ltl3ba(formula);
    }

    static {
        String platform = System.getProperty("os.name").toLowerCase();
        String resource = "/properties/LTL/ltl3ba/exe/";
        String suffix = "";
        if (platform.contains("mac")) {
            resource = resource + "macos/ltl3ba";
            suffix = "ltl3ba";
        } else if (platform.contains("linux")) {
            resource = resource + "linux/ltl3ba";
            suffix = "ltl3ba";
        } else {
            resource = resource + "windows/ltl3ba.exe";
            suffix = "ltl3ba.exe";
        }
        Path executablePath = null;
        try (InputStream inStream = LTL3BA.class.getResourceAsStream(resource);){
            executablePath = Files.createTempFile("plug", suffix, new FileAttribute[0]);
            try (OutputStream outStream = Files.newOutputStream(executablePath, new OpenOption[0]);){
                byte[] buffer = new byte[10240];
                int len = inStream.read(buffer);
                while (len != -1) {
                    outStream.write(buffer, 0, len);
                    len = inStream.read(buffer);
                }
            }
            executablePath.toFile().setExecutable(true, false);
        }
        catch (IOException e) {
            System.err.println("Can't create temp file to extract ltl3ba");
        }
        ltl3bPath = executablePath;
    }
}

