/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer.buchi.scc;

import java.util.Stack;
import java.util.function.Supplier;
import plug.core.IBuchiConfiguration;
import plug.core.IConfiguration;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.events.ExecutionEndedEvent;
import plug.events.PropertyEvent;
import plug.explorer.buchi.DefaultExecutionController;

public class BA_Couvreur_Recursive<C extends IBuchiConfiguration & IConfiguration, A>
extends DefaultExecutionController<C, A> {
    int count = 0;
    Stack<C> roots = new Stack();

    public BA_Couvreur_Recursive(ITransitionRelation<C, A> runtime) {
        super(runtime);
    }

    @Override
    public Supplier getMetadataSupplier() {
        return () -> new Metadata();
    }

    @Override
    public void execute() {
        for (IBuchiConfiguration initial : this.getProductAutomaton().initialConfigurationsIterable()) {
            this.couvreur_dfs(initial);
        }
        this.announcer.announce(new ExecutionEndedEvent((IExecutionController)this));
    }

    void couvreur_dfs(C source) {
        ++this.count;
        this.data(source).dfsnum = this.count;
        this.roots.push(source);
        this.data(source).current = true;
        for (IBuchiConfiguration t : this.getProductAutomaton().getPostIterable(source)) {
            IBuchiConfiguration u;
            if (this.monitor.atEnd()) break;
            if (this.data(t).dfsnum == 0) {
                this.couvreur_dfs(t);
                continue;
            }
            if (!this.data(t).current) continue;
            do {
                if (!(u = (IBuchiConfiguration)this.roots.pop()).isAccepting()) continue;
                System.out.println("target = [" + u + "]");
                this.announcer.announce(new PropertyEvent(this, false, "property", null));
            } while (this.data(u).dfsnum > this.data(t).dfsnum);
            this.roots.push(u);
        }
        if (this.roots.peek() == source) {
            this.roots.pop();
            this.remove(source);
        }
    }

    void remove(C s) {
        if (!this.data(s).current) {
            return;
        }
        this.data(s).current = false;
        for (IBuchiConfiguration t : this.getProductAutomaton().getPostIterable(s)) {
            this.remove(t);
        }
    }

    Metadata data(C state) {
        return (Metadata)((IConfiguration)state).getMetadata();
    }

    class Metadata {
        public int dfsnum = 0;
        public boolean current = false;

        Metadata() {
        }
    }
}

