/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer;

import java.util.Collection;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.events.CloseConfigurationEvent;
import plug.events.FiredEvent;
import plug.events.OpenConfigurationEvent;
import plug.explorer.AbstractExplorer;
import plug.simulation.selection.FireableTransitionsEvent;
import plug.simulation.selection.ISelectionPolicy;
import plug.simulation.selection.InteractiveSelectionPolicy;

public class Simulator<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    C toSee;
    private ISelectionPolicy policy = new InteractiveSelectionPolicy();

    public Simulator(ITransitionRelation<C, ?> runtime, IStateSpaceManager<C, A> stateSpaceManager) {
        super(runtime, stateSpaceManager);
    }

    public ISelectionPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ISelectionPolicy policy) {
        this.policy = policy;
    }

    @Override
    public void initializeExploration() {
        super.initializeExploration();
        this.toSee = (IConfiguration)this.stateSpaceManager.initialConfigurations().stream().iterator().next();
    }

    @Override
    boolean atEnd() {
        return this.toSee == null;
    }

    @Override
    C nextConfiguration() {
        return this.toSee;
    }

    @Override
    void schedule(C conf) {
        IConfiguration target = (IConfiguration)this.stateSpaceManager.get(conf);
        if (target == null) {
            target = (IConfiguration)this.stateSpaceManager.put(conf);
        }
        this.toSee = target;
    }

    @Override
    public void explorationStep() {
        C source = this.nextConfiguration();
        this.announcer.announce(new OpenConfigurationEvent<C>(this, source));
        Collection fireables = this.getRuntime().fireableTransitionsFrom(source);
        this.announcer.announce(new FireableTransitionsEvent(fireables));
        this.fire(this.policy.chooseTargets(fireables), source);
        this.announcer.announce(new CloseConfigurationEvent<C>(this, source));
    }

    public void fire(Collection<?> fireable, C source) {
        for (Object transition : fireable) {
            if (this.monitor.atEnd()) {
                return;
            }
            IFiredTransition<C, ?> fired = this.getRuntime().fireOneTransition(source, transition);
            this.announcer.announce(new FiredEvent(this, fired));
            this.stateSpaceManager.putTransition(fired);
            fired.getTargets().forEach(this::schedule);
        }
    }
}

