/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.transformations;

import java.util.Stack;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.BinaryExpression;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Element;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.False;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.True;
import properties.PropositionalLogic.PropositionalLogicModel.util.PropositionalLogicModelSwitch;

public class PrettyPrinter
extends PropositionalLogicModelSwitch<String> {
    Stack<Integer> tabs = new Stack();

    public static String print(Element e) {
        PrettyPrinter pp = new PrettyPrinter();
        return (String)pp.doSwitch(e);
    }

    @Override
    public String caseTrue(True object) {
        return "true";
    }

    @Override
    public String caseFalse(False object) {
        return "false";
    }

    @Override
    public String caseAtom(Atom object) {
        String delim = object.getDelimiterString();
        if (delim == null) {
            if (object.getCode().indexOf(124) == -1) {
                delim = "|";
            } else if (object.getCode().indexOf(34) == -1) {
                delim = "\"";
            }
        }
        return (object.getLanguage() == null ? "" : object.getLanguage()) + delim + object.getCode() + delim;
    }

    @Override
    public String caseExpressionReference(ExpressionReference object) {
        return object.getExp().getName();
    }

    @Override
    public String caseLogicalNegation(LogicalNegation object) {
        return object.getOperatorToken() + " " + (String)this.doSwitch(object.getOperand());
    }

    @Override
    public String caseBinaryExpression(BinaryExpression object) {
        String lhs = (String)this.doSwitch(object.getLhs());
        String rhs = (String)this.doSwitch(object.getRhs());
        return "(" + lhs + " " + object.getOperatorToken() + " " + rhs + ")";
    }

    @Override
    public String caseExpressionDeclaration(ExpressionDeclaration object) {
        return object.getName() + " = " + (String)this.doSwitch(object.getExpression());
    }

    @Override
    public String caseDeclarationBlock(DeclarationBlock object) {
        String result = "";
        for (Declaration eD : object.getDeclarations()) {
            result = result + (String)this.doSwitch(eD) + "\n";
        }
        return result;
    }

    private void pushTab() {
        this.tabs.push(0);
    }

    private void popTab() {
        this.tabs.pop();
    }

    private void inctab() {
        this.tabs.set(this.tabs.size() - 1, this.tabs.peek() + 1);
    }

    private void dectab() {
        this.tabs.set(this.tabs.size() - 1, this.tabs.peek() - 1);
    }

    private String tabs() {
        String s = "";
        for (int j = 0; j < this.tabs.size(); ++j) {
            int tab = (Integer)this.tabs.get(j);
            for (int i = 0; i < tab; ++i) {
                s = s + "\t";
            }
        }
        return s;
    }

    @Override
    public String caseLetExpression(LetExpression object) {
        String result = "let\n";
        this.pushTab();
        this.inctab();
        for (Declaration eD : object.getDeclarations()) {
            result = result + this.tabs() + (String)this.doSwitch(eD) + "\n";
        }
        this.dectab();
        result = result + this.tabs() + "in\n";
        this.inctab();
        result = result + this.tabs() + (String)this.doSwitch(object.getExpression());
        this.popTab();
        return result;
    }
}

