/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.sk_tba;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IBuchiConfiguration;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.language.buchi.runtime.BuchiConfiguration;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiAtomicPropositionsEvaluator;
import plug.language.buchikripke.runtime.KripkeBuchiConfiguration;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.statespace.transitions.FiredTransition;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.PropositionalLogic.interpreter.EvaluatorSpaghetti;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;

public class SK_TBA_ProductSemantics
implements ITransitionRelation<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> {
    protected final RuntimeDescription kripke;
    protected final RuntimeDescription buchi;
    protected ITransitionRelation<IConfiguration, Object> kripkeRuntime;
    protected BuchiRuntime buchiRuntime;
    protected KripkeBuchiAtomicPropositionsEvaluator atomicPropositionsEvaluator = null;
    protected final EvaluatorSpaghetti evaluator = new EvaluatorSpaghetti();
    protected final AtomArrayValuationEvaluator apValuationEvaluator;
    boolean hasDeadlockAP = false;

    public SK_TBA_ProductSemantics(RuntimeDescription kripke, RuntimeDescription buchi) throws Exception {
        this.kripke = kripke;
        this.buchi = buchi;
        ITransitionRelation runtime = buchi.getRuntime();
        this.buchiRuntime = runtime instanceof BuchiRuntime ? (BuchiRuntime)runtime : null;
        this.kripkeRuntime = kripke.getRuntime();
        HashMap<Object, Integer> atomMap = new HashMap<Object, Integer>();
        int idx = 0;
        for (Object atom : this.getBuchiRuntime().getAtomicPropositions()) {
            if (!((String)atom).equals("deadlock")) continue;
            this.hasDeadlockAP = true;
            atomMap.put(atom, idx++);
            break;
        }
        ArrayList<String> atoms = new ArrayList<String>();
        for (String atom : this.getBuchiRuntime().getAtomicPropositions()) {
            if (atom == null || atomMap.containsKey(atom)) continue;
            atomMap.put(atom, idx++);
            atoms.add(atom);
        }
        IAtomicPropositionsEvaluator kripkeEvaluator = this.getKripkeRuntime().getAtomicPropositionEvaluator();
        kripkeEvaluator.registerAtomicPropositions(atoms.toArray(new String[0]));
        this.apValuationEvaluator = new AtomArrayValuationEvaluator(atomMap);
        this.evaluator.setDefaultEvaluator((IAtomEvaluator)this.apValuationEvaluator);
    }

    public SK_TBA_ProductSemantics(RuntimeDescription kripke, BuchiRuntime buchiRuntime) throws Exception {
        this(kripke, new RuntimeDescription(null, () -> buchiRuntime));
    }

    public RuntimeDescription getKripke() {
        return this.kripke;
    }

    public RuntimeDescription getBuchi() {
        return this.buchi;
    }

    protected ITransitionRelation<IConfiguration, Object> getKripkeRuntime() {
        return this.kripkeRuntime;
    }

    protected BuchiRuntime getBuchiRuntime() {
        return this.buchiRuntime;
    }

    public Set<KripkeBuchiConfiguration> initialConfigurations() {
        HashSet<KripkeBuchiConfiguration> result = new HashSet<KripkeBuchiConfiguration>();
        for (IConfiguration cKripke : this.getKripkeRuntime().initialConfigurations()) {
            for (IBuchiConfiguration cBuchi : this.getBuchiRuntime().initialConfigurations()) {
                KripkeBuchiConfiguration kbc = new KripkeBuchiConfiguration();
                kbc.kripke = cKripke;
                kbc.buchiState = cBuchi;
                result.add(kbc);
            }
        }
        return result;
    }

    public Collection<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> fireableTransitionsFrom(KripkeBuchiConfiguration source) {
        ArrayList<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> synchronousFireables = new ArrayList<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>>();
        Collection kFireableTransitions = this.getKripkeRuntime().fireableTransitionsFrom((Object)source.kripke);
        int numberOfFireableTransitions = kFireableTransitions.size();
        for (Object kripkeFireable : kFireableTransitions) {
            IFiredTransition kripkeTransition = this.getKripkeRuntime().fireOneTransition((Object)source.kripke, kripkeFireable);
            if (kripkeTransition == null || kripkeTransition.getTargets() == null || kripkeTransition.getTargets().isEmpty()) {
                if (this.getKripkeRuntime().hasBlockingTransitions()) {
                    --numberOfFireableTransitions;
                    continue;
                }
                throw new RuntimeException("The runtime " + this.getKripkeRuntime() + " does not have blocking transitions, yet it didn't produce a target when firing " + kripkeFireable + " in " + source.kripke);
            }
            this.getKripkeBuchiSynchronousTransitions(source, kripkeTransition, synchronousFireables);
        }
        if (numberOfFireableTransitions == 0) {
            this.getKripkeBuchiSynchronousTransitions(source, KripkeBuchiProductSemantics.StutteringTransition.instance, synchronousFireables);
        }
        return synchronousFireables;
    }

    public IAtomicPropositionsEvaluator<KripkeBuchiConfiguration, Object> getAtomicPropositionEvaluator() {
        if (this.atomicPropositionsEvaluator == null) {
            this.atomicPropositionsEvaluator = new KripkeBuchiAtomicPropositionsEvaluator(this.getKripkeRuntime().getAtomicPropositionEvaluator());
        }
        return this.atomicPropositionsEvaluator;
    }

    public IFiredTransition<KripkeBuchiConfiguration, ?> fireOneTransition(KripkeBuchiConfiguration source, Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition> transition) {
        KripkeBuchiConfiguration myNewState = source.createCopy();
        myNewState.kripke = (IConfiguration)((IFiredTransition)transition.a).getTargets().iterator().next();
        IFiredTransition buchiTransition = this.getBuchiRuntime().fireOneTransition((BuchiConfiguration)source.buchiState, (GuardedTransition)transition.b);
        myNewState.buchiState = (IBuchiConfiguration)buchiTransition.getTarget(0);
        return new FiredTransition((Object)source, (Object)myNewState, transition);
    }

    public void close() {
        this.getKripkeRuntime().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getKripkeBuchiSynchronousTransitions(KripkeBuchiConfiguration source, Object kripkeFiredTransition, Collection<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> outFireables) {
        Collection<Object> kripkeTargets;
        Object kripkeFireable = null;
        Object kripkePayload = null;
        boolean isDeadlock = false;
        if (kripkeFiredTransition == KripkeBuchiProductSemantics.StutteringTransition.instance) {
            kripkeFireable = kripkeFiredTransition;
            kripkeTargets = Collections.singleton(source.kripke);
            isDeadlock = true;
        } else {
            IFiredTransition transition = (IFiredTransition)kripkeFiredTransition;
            kripkeFireable = transition.getAction();
            kripkePayload = transition.getPayload();
            kripkeTargets = transition.getTargets();
        }
        IAtomicPropositionsEvaluator apEvaluator = this.getKripkeRuntime().getAtomicPropositionEvaluator();
        for (IConfiguration iConfiguration : kripkeTargets) {
            AtomArrayValuationEvaluator atomArrayValuationEvaluator = this.apValuationEvaluator;
            synchronized (atomArrayValuationEvaluator) {
                boolean[] valuation;
                if (!isDeadlock) {
                    valuation = apEvaluator.getAtomicPropositionValuations(source.kripke, kripkeFireable == kripkeFiredTransition ? null : kripkeFireable, kripkePayload, iConfiguration);
                    if (!this.hasDeadlockAP) {
                        this.apValuationEvaluator.setValuation(valuation);
                    } else {
                        boolean[] v = new boolean[valuation.length + 1];
                        v[0] = isDeadlock;
                        System.arraycopy(valuation, 0, v, 1, valuation.length);
                        this.apValuationEvaluator.setValuation(v);
                    }
                } else {
                    valuation = new boolean[this.apValuationEvaluator.atomicPropositions.size()];
                    if (this.hasDeadlockAP) {
                        valuation[0] = true;
                    }
                    this.apValuationEvaluator.setValuation(valuation);
                }
                Collection buchiTransitions = this.getBuchiRuntime().fireableTransitionsFrom((BuchiConfiguration)source.buchiState);
                for (GuardedTransition buchiTransition : buchiTransitions) {
                    if (!this.evaluator.evaluate(buchiTransition.getGuard())) continue;
                    outFireables.add((Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>)new Pair((Object)new FiredTransition((Object)source.kripke, (Object)iConfiguration, kripkeFireable), (Object)buchiTransition));
                }
            }
        }
    }
}

