/*
 * Decompiled with CFR 0.152.
 */
package plug.core.ui.common;

import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import plug.core.ILanguagePlugin;
import plug.core.RuntimeDescription;
import plug.core.execution.Execution;
import plug.core.execution.ExecutionException;
import plug.core.execution.ExecutionOLD;
import plug.core.ui.common.IPropertiesModule;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiLoader;
import plug.language.buchikripke.runtime.KripkeBuchiPlugin;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.language.buchikripke.sk_tba.SK_TBA_Loader;
import plug.language.buchikripke.sk_tba.SK_TBA_Plugin;
import plug.language.buchikripke.sk_tba.SK_TBA_ProductSemantics;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.DeclarationBlock;
import properties.BuchiAutomata.analysis.AcceptAllExtractor;
import properties.LTL.parser.Parser;
import properties.LTL.transformations.LTL2Buchi;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;

public class GPSL2Execution
implements IPropertiesModule {
    @Override
    public String getName() {
        return "LTL Properties";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".gpsl"};
    }

    public Collection<Execution> executionsNEW(Path propertiesPath, RuntimeDescription modelDescription) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        LTL2Buchi convertor = new LTL2Buchi(new PrintWriter(System.out));
        Collection buchiDeclarations = convertor.getBuchiDeclarations((ANTLRInputStream)is);
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (BuchiDeclaration buchi : buchiDeclarations) {
            AcceptAllExtractor aae = new AcceptAllExtractor();
            Set acceptAllSet = aae.getAcceptAllSet(buchi);
            Execution execution = new Execution(buchi.getName(), modelDescription.modelPath, this.sk_tba_plugin(modelDescription, new RuntimeDescription(null, () -> new BuchiRuntime(buchi))), BA_GaiserSchwoon_Iterative::new, acceptAllSet);
            executions.add(execution);
        }
        return executions;
    }

    public Execution executionNEW(String name, Path propertiesPath, RuntimeDescription modelDescription, Execution.TransitionStorageType transitionStorageType) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        LTL2Buchi converter = new LTL2Buchi(new PrintWriter(System.out));
        BuchiDeclaration buchi = converter.getBuchiDeclaration(name, (ANTLRInputStream)is);
        AcceptAllExtractor aae = new AcceptAllExtractor();
        Set acceptAllSet = aae.getAcceptAllSet(buchi);
        Execution execution = new Execution(buchi.getName(), modelDescription.modelPath, this.sk_tba_plugin(modelDescription, new RuntimeDescription(null, () -> new BuchiRuntime(buchi))), BA_GaiserSchwoon_Iterative::new, transitionStorageType, acceptAllSet);
        return execution;
    }

    ILanguagePlugin sk_tba_plugin(final RuntimeDescription modelDescription, final RuntimeDescription buchiDescription) {
        final SK_TBA_Loader loader = new SK_TBA_Loader(){

            public SK_TBA_ProductSemantics getRuntime(URI modelURI, Map<String, Object> options) throws Exception {
                return new SK_TBA_ProductSemantics(modelDescription, buchiDescription);
            }
        };
        SK_TBA_Plugin plugin = new SK_TBA_Plugin(){

            public SK_TBA_Loader getLoader() {
                return loader;
            }
        };
        return plugin;
    }

    ILanguagePlugin b2k_plugin(final RuntimeDescription modelDescription, final RuntimeDescription buchiDescription) {
        final KripkeBuchiLoader loader = new KripkeBuchiLoader(){

            public KripkeBuchiProductSemantics getRuntime(URI modelURI, Map<String, Object> options) throws Exception {
                return new KripkeBuchiProductSemantics(modelDescription, buchiDescription);
            }
        };
        KripkeBuchiPlugin plugin = new KripkeBuchiPlugin(){

            public KripkeBuchiLoader getLoader() {
                return loader;
            }
        };
        return plugin;
    }

    @Override
    @Deprecated
    public Collection<ExecutionOLD> executions(Path propertiesPath, RuntimeDescription modelDescription) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        ArrayList exceptions = new ArrayList();
        DeclarationBlock block = (DeclarationBlock)new Parser().parse((ANTLRInputStream)is, DeclarationBlock.class, exceptions::add);
        if (exceptions.size() > 0) {
            throw (Exception)exceptions.get(0);
        }
        ArrayList<ExecutionOLD> executions = new ArrayList<ExecutionOLD>();
        for (Declaration declaration : block.getDeclarations()) {
            executions.add(this.createExecution(declaration, modelDescription));
        }
        return executions;
    }

    @Deprecated
    public ExecutionOLD createExecution(Declaration property, RuntimeDescription modelDescription) {
        RuntimeDescription buchiDescription = new RuntimeDescription(null, () -> {
            LTL2Buchi convertor = new LTL2Buchi(new PrintWriter(System.out));
            return new BuchiRuntime(convertor.convert(property));
        });
        RuntimeDescription kripkeDescription = new RuntimeDescription((ILanguagePlugin)new KripkeBuchiPlugin(), () -> {
            try {
                return new KripkeBuchiProductSemantics(modelDescription, buchiDescription);
            }
            catch (Exception e) {
                throw new ExecutionException(null, (Throwable)e, false);
            }
        });
        return new ExecutionOLD(property.getName(), kripkeDescription, BA_GaiserSchwoon_Iterative::new);
    }
}

