/*
 * Decompiled with CFR 0.152.
 */
package plug.statespace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IConcurrentTransitionRelation;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IProductAutomaton;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;

public class LazyProductAutomaton<C extends IConfiguration, F>
implements IConcurrentTransitionRelation<LazyProductAutomaton<C, F>, C, F>,
IProductAutomaton<C, F> {
    private final ITransitionRelation<C, F> runtime;
    private final IStateSpaceManager<C, F> stateSpaceManager;
    protected final Supplier metadataSupplier;

    public LazyProductAutomaton(ITransitionRelation<C, F> runtime, IStateSpaceManager<C, F> stateSpaceManager, Supplier metadataSupplier) {
        this.runtime = runtime;
        this.stateSpaceManager = stateSpaceManager;
        this.metadataSupplier = metadataSupplier;
    }

    @Override
    public LazyProductAutomaton<C, F> createCopy() {
        return new LazyProductAutomaton<C, F>(((IConcurrentTransitionRelation)this.runtime).createCopy(), this.stateSpaceManager, this.metadataSupplier);
    }

    @Override
    public boolean hasBlockingTransitions() {
        return this.runtime.hasBlockingTransitions();
    }

    @Override
    public Set<C> initialConfigurations() {
        HashSet<IConfiguration> set = new HashSet<IConfiguration>();
        for (IConfiguration c : this.initialConfigurationsIterable()) {
            set.add(c);
        }
        return set;
    }

    @Override
    public Collection<F> fireableTransitionsFrom(C source) {
        ArrayList<F> col = new ArrayList<F>();
        for (F f : this.fireableTransitionsIterable(source)) {
            col.add(f);
        }
        return col;
    }

    @Override
    public IFiredTransition<C, ?> fireOneTransition(C source, F transition) {
        return this.runtime.fireOneTransition(source, transition);
    }

    @Override
    public Iterable<C> initialConfigurationsIterable() {
        return () -> new InitialConfigurationIterator(this.runtime.initialConfigurations());
    }

    @Override
    public Iterable<F> fireableTransitionsIterable(C source) {
        return () -> this.runtime.fireableTransitionsFrom((IConfiguration)source).iterator();
    }

    @Override
    public Iterable<C> getPostIterable(C source) {
        return () -> new PostIterator(this, source);
    }

    @Override
    public IAtomicPropositionsEvaluator getAtomicPropositionEvaluator() {
        return this.runtime.getAtomicPropositionEvaluator();
    }

    public static class PostIterator
    implements Iterator<C> {
        final C source;
        private Iterator<F> fireables;
        private Iterator<C> postIterator;
        public IFiredTransition currentFiredTransition;
        final /* synthetic */ LazyProductAutomaton this$0;

        PostIterator(C source) {
            this.this$0 = this$0;
            this.source = source;
            this.fireables = this$0.fireableTransitionsIterable(source).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.postIterator != null) {
                if (this.postIterator.hasNext()) {
                    return true;
                }
                this.this$0.stateSpaceManager.putTransition(this.currentFiredTransition);
            }
            if (this.fireables != null) {
                while (this.fireables.hasNext()) {
                    this.currentFiredTransition = this.this$0.fireOneTransition(this.source, this.fireables.next());
                    if (this.currentFiredTransition == null) continue;
                    this.postIterator = this.currentFiredTransition.getTargets().iterator();
                    if (!this.postIterator.hasNext()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public C next() {
            IConfiguration newNext = (IConfiguration)this.postIterator.next();
            IConfiguration next = this.this$0.stateSpaceManager.get(newNext);
            if (next == null) {
                newNext.setMetadata(this.this$0.metadataSupplier.get());
                next = newNext;
                this.this$0.stateSpaceManager.put(next);
            }
            return next;
        }
    }

    class InitialConfigurationIterator
    implements Iterator<C> {
        Iterator<C> runtimeInitialConfigurationIterator;

        InitialConfigurationIterator(Set<C> initialConfigurations) {
            this.runtimeInitialConfigurationIterator = initialConfigurations.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.runtimeInitialConfigurationIterator.hasNext();
        }

        @Override
        public C next() {
            IConfiguration newNext = (IConfiguration)this.runtimeInitialConfigurationIterator.next();
            IConfiguration next = LazyProductAutomaton.this.stateSpaceManager.get(newNext);
            if (next == null) {
                next = newNext;
                LazyProductAutomaton.this.stateSpaceManager.putInitial(next);
                next.setMetadata(LazyProductAutomaton.this.metadataSupplier.get());
            }
            return next;
        }
    }
}

