/*
 * Decompiled with CFR 0.152.
 */
package plug.folding.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.folding.runtime.FoldingExecutionController;
import plug.statespace.transitions.FiredTransition;

public class FoldingRuntime<C, A>
implements ITransitionRelation<C, A> {
    public ITransitionRelation<C, A> baseRuntime;
    Predicate<C> foldingPredicate;
    Function<ITransitionRelation<C, A>, IExecutionController<C, A>> controllerSupplier;

    public FoldingRuntime(ITransitionRelation<C, A> baseRuntime, Predicate<C> foldingPredicate, Function<ITransitionRelation<C, A>, IExecutionController<C, A>> controllerSupplier) {
        this.baseRuntime = baseRuntime;
        this.foldingPredicate = foldingPredicate;
        this.controllerSupplier = controllerSupplier;
    }

    @Override
    public Set<C> initialConfigurations() {
        return this.baseRuntime.initialConfigurations();
    }

    @Override
    public Collection<A> fireableTransitionsFrom(C source) {
        return this.baseRuntime.fireableTransitionsFrom(source);
    }

    @Override
    public IFiredTransition<C, ?> fireOneTransition(C source, A transition) {
        IFiredTransition<C, ?> fired = this.baseRuntime.fireOneTransition(source, transition);
        if (fired == null) {
            return null;
        }
        HashSet<C> targets = new HashSet<C>();
        for (C target : fired.getTargets()) {
            if (this.foldingPredicate.test(target)) {
                FoldingExecutionController<C, A> controller = new FoldingExecutionController<C, A>(target, this.baseRuntime, this.foldingPredicate, this.controllerSupplier);
                controller.execute();
                if (controller.getStateSpaceManager().size() > 50) {
                    System.out.println("Fold size : " + controller.getStateSpaceManager().size());
                }
                targets.addAll(controller.foldingOutputs);
                continue;
            }
            targets.add(target);
        }
        return new FiredTransition(source, targets, transition);
    }

    @Override
    public boolean hasBlockingTransitions() {
        return this.baseRuntime.hasBlockingTransitions();
    }

    @Override
    public IAtomicPropositionsEvaluator getAtomicPropositionEvaluator() {
        return this.baseRuntime.getAtomicPropositionEvaluator();
    }
}

