# Copyright © 2021 rdbende <rdbende@gmail.com>

source [file join [file dirname [info script]] light.tcl]
source [file join [file dirname [info script]] dark.tcl]

proc set_azure_theme {mode} {
    
    option add *tearOff 0
    
    set font_names {"Segoe Ui" "DejaVu Sans" "Open Sans" "Noto Sans" "Roboto" "Arial"}
    set font_name ""
    foreach fn $font_names {
      if {[lsearch [font families] "$fn"] != -1} {
        set font_name $fn
        break
      }
    }
    if {$font_name == ""} { set font_name "Sans" }
    
    set dark_theme_colors [dict create "dark-bright_blue" "#007fff" "dark-forest_green" "#59a687" "dark-mint_green" "#7bac53" "dark-violet" "#be26d9" "dark-orange" "#ff8000"]
    set light_theme_colors [dict create "light-bright_blue" "#007fff" "light-forest_green" "#59a687" "light-orange" "#ff8000" "light-teal" "#00ccff" "light-violet" "#be26d9"]
  
    if [dict exists $dark_theme_colors $mode] {
        ttk::style theme use "azure-$mode"

        array set colors [list \
            -fg             "#ffffff" \
            -bg             "#333333" \
            -disabledfg     "#ffffff" \
            -disabledbg     "#737373" \
            -selectfg       "#ffffff" \
            -selectbg       [dict get $dark_theme_colors $mode] \
        ]
        
        ttk::style configure . \
            -background $colors(-bg) \
            -foreground $colors(-fg) \
            -troughcolor $colors(-bg) \
            -focuscolor $colors(-selectbg) \
            -selectbackground $colors(-selectbg) \
            -selectforeground $colors(-selectfg) \
            -insertcolor $colors(-fg) \
            -insertwidth 1 \
            -fieldbackground $colors(-selectbg) \
            -font [list "$font_name" 10] \
            -borderwidth 1 \
            -relief flat

        tk_setPalette background [ttk::style lookup . -background] \
            foreground [ttk::style lookup . -foreground] \
            highlightColor [ttk::style lookup . -focuscolor] \
            selectBackground [ttk::style lookup . -selectbackground] \
            selectForeground [ttk::style lookup . -selectforeground] \
            activeBackground [ttk::style lookup . -selectbackground] \
            activeForeground [ttk::style lookup . -selectforeground]

        ttk::style map . -foreground [list disabled $colors(-disabledfg)]

        option add *font [ttk::style lookup . -font]
        option add *Menu.selectcolor $colors(-fg)
        option add *TCombobox*Listbox.background $colors(-bg)
        option add *Text.background white
        option add *Text.foreground black
        option add *Text.insertBackground [ttk::style lookup . -selectbackground]
    
    } elseif [dict exists $light_theme_colors $mode] {
      
        ttk::style theme use "azure-$mode"

        array set colors [list \
            -fg             "#000000" \
            -bg             "#ffffff" \
            -disabledfg     "#737373" \
            -disabledbg     "#ffffff" \
            -selectfg       "#ffffff" \
            -selectbg       [dict get $light_theme_colors $mode] \
        ]

        ttk::style configure . \
            -background $colors(-bg) \
            -foreground $colors(-fg) \
            -troughcolor $colors(-bg) \
            -focuscolor $colors(-selectbg) \
            -selectbackground $colors(-selectbg) \
            -selectforeground $colors(-selectfg) \
            -insertcolor $colors(-fg) \
            -insertwidth 1 \
            -fieldbackground $colors(-selectbg) \
            -font [list "$font_name" 10] \
            -borderwidth 1 \
            -relief flat

        tk_setPalette background [ttk::style lookup . -background] \
            foreground [ttk::style lookup . -foreground] \
            highlightColor [ttk::style lookup . -focuscolor] \
            selectBackground [ttk::style lookup . -selectbackground] \
            selectForeground [ttk::style lookup . -selectforeground] \
            activeBackground [ttk::style lookup . -selectbackground] \
            activeForeground [ttk::style lookup . -selectforeground]

        ttk::style map . -foreground [list disabled $colors(-disabledfg)]

        option add *font [ttk::style lookup . -font]
        option add *Menu.selectcolor $colors(-fg)
        option add *TCombobox*Listbox.background $colors(-bg)
    }
}
