/*
 * Decompiled with CFR 0.152.
 */
package obp2.core.registry;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;

public class LanguageModuleRegistry {
    private final Map<String, ILanguagePlugin<?, ?, ?, ?>> languageNameMap = new HashMap();
    private final Map<String, ILanguagePlugin<?, ?, ?, ?>> extensionMap = new HashMap();
    private static LanguageModuleRegistry instance = null;

    private LanguageModuleRegistry() {
    }

    public ILanguagePlugin<?, ?, ?, ?> getModuleByName(String name) {
        return this.languageNameMap.get(name);
    }

    public ILanguagePlugin<?, ?, ?, ?> getModuleByExtension(URI fileURI) {
        return this.getModuleByExtension(Paths.get(fileURI.getPath(), new String[0]));
    }

    public ILanguagePlugin<?, ?, ?, ?> getModuleByExtension(Path filePath) {
        if (filePath == null) {
            return null;
        }
        String fileName = filePath.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex < 1) {
            return null;
        }
        String fileExtension = fileName.substring(dotIndex);
        ILanguagePlugin<?, ?, ?, ?> plugin = this.extensionMap.get(fileExtension);
        if (plugin == null) {
            throw new RuntimeException("Could not load the languagePlugin for " + filePath);
        }
        return plugin;
    }

    public static Supplier<ILanguageModule> getLanguageModuleSupplier(Path modelPath) {
        return () -> LanguageModuleRegistry.getLanguageModule(modelPath);
    }

    public static ILanguageModule<Object, Object, Object> getLanguageModule(Path modelPath) {
        ILanguagePlugin<?, ?, ?, ?> plugin = LanguageModuleRegistry.getInstance().getModuleByExtension(modelPath);
        return (ILanguageModule)plugin.languageModuleFunction().apply(modelPath.toUri());
    }

    public Collection<ILanguagePlugin> getModules() {
        return Collections.unmodifiableCollection(this.languageNameMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LanguageModuleRegistry getInstance() {
        if (instance != null) return instance;
        Class<LanguageModuleRegistry> clazz = LanguageModuleRegistry.class;
        synchronized (LanguageModuleRegistry.class) {
            if (instance != null) return instance;
            instance = new LanguageModuleRegistry();
            for (ILanguagePlugin languagePlugin : ServiceLoader.load(ILanguagePlugin.class)) {
                System.out.println("Loading " + languagePlugin.getName() + " language plugin");
                LanguageModuleRegistry.instance.languageNameMap.put(languagePlugin.getName(), languagePlugin);
                for (String extension : languagePlugin.getExtensions()) {
                    LanguageModuleRegistry.instance.extensionMap.put(extension, languagePlugin);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

