/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2;

import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import obp2.core.fx.IAppContext;
import obp2.ui2.OutputRedirect;
import org.controlsfx.control.StatusBar;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.utils.file.FileWatcher;
import plug.utils.ui.fx.GuiFxUtils;

public abstract class AbstractUIBase
extends Application
implements IAppContext {
    FileWatcher fileWatcher = new FileWatcher();
    Stage stage;
    public Scene mainScene;
    private static boolean firstDisplay = true;
    Scene theScene = new Scene((Parent)new OutputRedirect());
    final ObjectProperty<Stage> theErrorStage = new SimpleObjectProperty();

    @Override
    public FileWatcher getFileWatcher() {
        return this.fileWatcher;
    }

    @Override
    public void openView(String title, Region view, Consumer<Region> onClose) {
        BorderPane mainPane = new BorderPane();
        mainPane.setCenter((Node)view);
        FontIcon closeIcon = new FontIcon("gmi-close:20");
        GuiFxUtils.addButtonEffects((Node)closeIcon);
        closeIcon.setOnMouseClicked(event -> {
            boolean isMaximized = this.stage.isMaximized();
            if (firstDisplay) {
                this.stage.setMaximized(true);
                this.stage.setMaximized(false);
                firstDisplay = false;
            }
            this.stage.setScene(this.mainScene);
            this.mainScene.getWindow().setHeight(this.stage.getHeight());
            this.mainScene.getWindow().setWidth(this.stage.getWidth());
            if (isMaximized) {
                this.stage.setMaximized(true);
                firstDisplay = false;
            }
            if (onClose != null) {
                onClose.accept(view);
            }
        });
        Text titleText = new Text(title);
        titleText.setTextAlignment(TextAlignment.CENTER);
        BorderPane titlePane = new BorderPane((Node)titleText);
        titlePane.setLeft((Node)closeIcon);
        mainPane.setTop((Node)titlePane);
        Scene theScene = new Scene(this.buildMain((Node)mainPane), this.mainScene.getWidth(), this.mainScene.getHeight());
        this.addCSS(theScene);
        this.stage.setScene(theScene);
    }

    public void addCSS(Scene scene) {
        URL css = this.getClass().getResource("/obp2/ui2/style.css");
        GuiFxUtils.setStylesheet((URL)css, (Scene)scene, (FileWatcher)this.fileWatcher);
    }

    void showErrorHandler(MouseEvent me) {
        Stage theStage = (Stage)this.theErrorStage.get();
        if (theStage == null) {
            theStage = new Stage();
            this.theErrorStage.set((Object)theStage);
            theStage.setScene(this.theScene);
            theStage.setTitle("Console Messages");
        }
        theStage.show();
        theStage.requestFocus();
    }

    public StatusBar getStatusBar() {
        StatusBar statusBar = new StatusBar();
        statusBar.setText("");
        FontIcon errorIcon = new FontIcon("gmi-error-outline:20:#FF0000");
        errorIcon.setOnMouseClicked(this::showErrorHandler);
        statusBar.getRightItems().addAll((Object[])new Node[]{errorIcon});
        return statusBar;
    }

    public abstract Node getMainComponent();

    public void init() throws Exception {
        super.init();
        this.mainScene = new Scene(this.buildMain(this.getMainComponent()), 800.0, 600.0);
    }

    Parent buildMain(Node node) {
        return new BorderPane(node, null, null, (Node)this.getStatusBar(), null);
    }

    public void start(Stage primaryStage) {
        this.stage = primaryStage;
        this.stage.setOnCloseRequest(e -> {
            Platform.exit();
            System.exit(0);
        });
        this.addCSS(this.mainScene);
        this.stage.setScene(this.mainScene);
        this.stage.show();
    }
}

