/*
 * Decompiled with CFR 0.152.
 */
package obp2.visualisation;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import obp2.core.IFiredTransition;
import obp2.core.IGraphAccess;
import org.apache.commons.lang3.reflect.FieldUtils;
import plug.utils.marshaling.Marshaller;

public class StateSpace2ExplicitVHD<C, A, O> {
    public static final StateSpace2ExplicitVHD instace = new StateSpace2ExplicitVHD();
    Map<Class, Byte> classIntegerMap = new IdentityHashMap<Class, Byte>();

    public static void toVHD(IGraphAccess graphView, String modelName, String filename) {
        try {
            instace.toVHDL(graphView, modelName, filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toVHDL(IGraphAccess<C, A, O> graphView, String modelName, String filename) throws IOException {
        BufferedWriter br = new BufferedWriter(new FileWriter(filename));
        this.toVHDL(graphView, modelName, br);
    }

    void generateModelStructure(int nbStates, int nbTransitions, int nbInitial, int configurationSize, Writer writer) throws IOException {
        String structureString = "library IEEE;\nuse IEEE.STD_LOGIC_1164.ALL;\nuse WORK.explicit_params.ALL;\npackage model_structure is\n    constant CONFIG_WIDTH : integer := " + configurationSize + ";\n    constant AB_PARAMS : T_MODEL_PARAMS := (" + nbStates + ", " + nbTransitions + ", " + nbInitial + ", CONFIG_WIDTH);\n\n    subtype T_CONFIGURATION is std_logic_vector(CONFIG_WIDTH-1 downto 0);\n    pure function config2lv(c : T_CONFIGURATION) return std_logic_vector;\n    pure function lv2config(lv : std_logic_vector) return T_CONFIGURATION;\nend package;\n\npackage body model_structure is\n    pure function config2lv(c : T_CONFIGURATION) return std_logic_vector is\n    begin\n    \treturn std_logic_vector(c);\n    end function;\n\n    pure function lv2config(lv : std_logic_vector) return T_CONFIGURATION is\n    begin\n        return T_CONFIGURATION(lv);\n    end function;\nend package body;";
        writer.write(structureString);
    }

    public void toVHDL(IGraphAccess<C, A, O> graphView, String modelName, Writer inWriter) throws IOException {
        int nbStates = graphView.getVertices().size();
        int nbTransitions = 0;
        int nbInitial = graphView.getInitialVertices().size();
        int configurationSize = 0;
        File modelFile = File.createTempFile("model", Long.toString(System.currentTimeMillis()));
        BufferedWriter writer = new BufferedWriter(new FileWriter(modelFile));
        HashMap idMap = new HashMap();
        writer.write("-- " + modelName + " state-space\n");
        writer.write("library IEEE;\n");
        writer.write("use IEEE.STD_LOGIC_1164.ALL;\n");
        writer.write("use WORK.explicit_structure.ALL;\n");
        writer.write("use WORK.model_structure.ALL;\n");
        writer.write("package model is\n");
        writer.write("\tconstant AB_MODEL : T_EXPLICIT := (\n");
        writer.write("\t\tstates => (\n");
        boolean first = true;
        for (Object vertex : graphView.getVertices()) {
            int id = this.getID(vertex, idMap);
            if (first) {
                first = false;
            } else {
                writer.write(",\n");
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(baos);
                this.toBinary(vertex, 0, bos);
                bos.flush();
                String bits = "";
                byte[] bytes = baos.toByteArray();
                for (int i = 0; i < bytes.length; ++i) {
                    String s = String.format("%8s", Integer.toBinaryString(bytes[i] & 0xFF)).replace(' ', '0');
                    bits = bits + s + "_";
                }
                int size = bytes.length * 8;
                if (configurationSize != 0 && configurationSize != size) {
                    System.err.println("VHDL generation does not support variable configuration size");
                    return;
                }
                configurationSize = bytes.length * 8;
                writer.write("\t\t\t" + id + " => B\"" + bits.substring(0, bits.length() - 1) + "\"");
            }
            catch (IllegalAccessException baos) {}
        }
        writer.write("\t\t),\n");
        writer.write("\t\tinitial => (");
        int idx = 0;
        for (Object vertex : graphView.getInitialVertices()) {
            if (idx != 0) {
                writer.write(", ");
            }
            writer.write(idx + " => " + this.getID(vertex, idMap));
            ++idx;
        }
        writer.write("),\n");
        writer.write("\t\tfanout => (");
        first = true;
        String fanoutBaseString = "";
        int source_idx = 0;
        idx = 0;
        for (Object source : graphView.getVertices()) {
            writer.write("\n\t\t\t");
            int sourceID = this.getID(source, idMap);
            if (sourceID == source_idx) {
                ++source_idx;
                if (!first) {
                    fanoutBaseString = fanoutBaseString + ", ";
                }
            } else {
                throw new RuntimeException("Source nodes should be handled using the ID order, found " + sourceID + " expected " + source_idx);
            }
            fanoutBaseString = fanoutBaseString + idx;
            for (IFiredTransition transition : graphView.getOutgoingEdges(source)) {
                for (Object target : transition.getTargets()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("" + this.getID(target, idMap));
                    ++idx;
                }
            }
            writer.write("\t\t\t-- fanout(" + sourceID + ")");
        }
        writer.write("\n\t\t),\n");
        writer.write("\t\tfanout_base => (" + fanoutBaseString + ", " + idx + ")\n");
        writer.write(");\n");
        writer.write("end package;\n");
        nbTransitions = idx;
        writer.close();
        BufferedReader br = new BufferedReader(new FileReader(modelFile));
        this.generateModelStructure(nbStates, nbTransitions, nbInitial, configurationSize, inWriter);
        inWriter.write("\n\n");
        br.lines().forEach(line -> {
            try {
                inWriter.write(line + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        inWriter.close();
    }

    int getID(C vertex, Map<C, Integer> idMap) {
        Integer id = idMap.get(vertex);
        if (id == null) {
            id = idMap.size();
            idMap.put(vertex, id);
        }
        return id;
    }

    String tab(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + "\t";
        }
        return s;
    }

    String toBinary(Object o, int level, OutputStream os) throws IllegalAccessException, IOException {
        Byte classID = this.classIntegerMap.get(o.getClass());
        if (classID == null) {
            if (this.classIntegerMap.size() > 127) {
                throw new RuntimeException("VHDL serialization does not support more than 127 classes");
            }
            classID = (byte)this.classIntegerMap.size();
            this.classIntegerMap.put(o.getClass(), classID);
        }
        if (level != 0 && !o.getClass().getSuperclass().getSimpleName().equals("BehaviorConfiguration")) {
            Marshaller.writeByte((byte)classID, (OutputStream)os);
        }
        ++level;
        for (Field field : FieldUtils.getAllFields(o.getClass())) {
            if (field.getName().equals("metadata") || level == 1 && o.getClass().getSimpleName().equals("FiacreConfiguration") && field.getName().equals("id")) continue;
            if (field.getType().isPrimitive()) {
                this.getPrimitive(field, o, level, os);
                continue;
            }
            if (field.getType().isArray()) {
                int i;
                Object arrO = field.get(o);
                if (arrO == null) {
                    Marshaller.writeBoolean((boolean)false, (OutputStream)os);
                    continue;
                }
                int length = Array.getLength(arrO);
                Marshaller.writeBoolean((boolean)true, (OutputStream)os);
                Marshaller.writeInt((int)length, (OutputStream)os);
                boolean isPrimitiveArray = true;
                if (arrO.getClass().getTypeName().equals("int[]")) {
                    for (i = 0; i < length; ++i) {
                        int element = Array.getInt(arrO, i);
                        Marshaller.writeInt((int)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("boolean[]")) {
                    for (i = 0; i < length; ++i) {
                        boolean element = Array.getBoolean(arrO, i);
                        Marshaller.writeBoolean((boolean)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("short[]")) {
                    for (i = 0; i < length; ++i) {
                        short element = Array.getShort(arrO, i);
                        Marshaller.writeShort((short)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("byte[]")) {
                    for (i = 0; i < length; ++i) {
                        byte element = Array.getByte(arrO, i);
                        Marshaller.writeByte((byte)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("char[]")) {
                    for (i = 0; i < length; ++i) {
                        char element = Array.getChar(arrO, i);
                        Marshaller.writeChar((char)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("long[]")) {
                    for (i = 0; i < length; ++i) {
                        long element = Array.getLong(arrO, i);
                        Marshaller.writeLong((long)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("float[]")) {
                    for (i = 0; i < length; ++i) {
                        float element = Array.getFloat(arrO, i);
                        Marshaller.writeFloat((float)element, (OutputStream)os);
                    }
                    continue;
                }
                if (arrO.getClass().getTypeName().equals("double[]")) {
                    for (i = 0; i < length; ++i) {
                        double element = Array.getDouble(arrO, i);
                        Marshaller.writeDouble((double)element, (OutputStream)os);
                    }
                    continue;
                }
                isPrimitiveArray = false;
                for (i = 0; i < length; ++i) {
                    Object element = Array.get(arrO, i);
                    this.toBinary(element, level + 1, os);
                }
                continue;
            }
            this.toBinary(field.get(o), level + 1, os);
        }
        return "";
    }

    String getPrimitive(Field field, Object o, int level, OutputStream os) throws IllegalAccessException, IOException {
        Class<?> clazz = field.getType();
        if (clazz.getSimpleName().equals("int")) {
            int value = field.getInt(o);
            Marshaller.writeInt((int)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("boolean")) {
            boolean value = field.getBoolean(o);
            Marshaller.writeBoolean((boolean)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("short")) {
            short value = field.getShort(o);
            Marshaller.writeShort((short)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("byte")) {
            byte value = field.getByte(o);
            Marshaller.writeByte((byte)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("char")) {
            char value = field.getChar(o);
            Marshaller.writeChar((char)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("long")) {
            long value = field.getLong(o);
            Marshaller.writeLong((long)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("float")) {
            float value = field.getFloat(o);
            Marshaller.writeFloat((float)value, (OutputStream)os);
        } else if (clazz.getSimpleName().equals("double")) {
            double value = field.getDouble(o);
            Marshaller.writeDouble((double)value, (OutputStream)os);
        } else {
            System.out.println(this.tab(level) + "(" + field.getName() + " UNEXPECTED)");
        }
        return "";
    }
}

