/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.parser;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.function.Consumer;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Element;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.grammar.PropositionalLogicLexer;
import properties.PropositionalLogic.grammar.PropositionalLogicParser;
import properties.PropositionalLogic.parser.ASTBuilder;
import properties.PropositionalLogic.parser.SymbolResolver;

public class Parser {
    private static Parser instance = new Parser();

    public static Expression parse(File file) throws IOException {
        ANTLRFileStream fs = new ANTLRFileStream(file.getAbsolutePath());
        return instance.parse((ANTLRInputStream)fs, Expression.class);
    }

    public static Expression parse(String program, Consumer<Exception> errorHandler) {
        ANTLRInputStream is = new ANTLRInputStream(program);
        return instance.parse(is, Expression.class, errorHandler);
    }

    public static Expression parse(String program) {
        ANTLRInputStream is = new ANTLRInputStream(program);
        return instance.parse(is, Expression.class);
    }

    public static DeclarationBlock parseBlock(File file) throws IOException {
        ANTLRFileStream fs = new ANTLRFileStream(file.getAbsolutePath());
        return instance.parse((ANTLRInputStream)fs, DeclarationBlock.class);
    }

    public static DeclarationBlock parseBlock(String program, Consumer<Exception> errorHandler) {
        ANTLRInputStream is = new ANTLRInputStream(program);
        return instance.parse(is, DeclarationBlock.class, errorHandler);
    }

    public static DeclarationBlock parseBlock(String program) {
        ANTLRInputStream is = new ANTLRInputStream(program);
        return instance.parse(is, DeclarationBlock.class);
    }

    public static URI generateModelXMI(Expression exp, String fileName) throws IOException {
        return instance.saveXMI(exp, fileName);
    }

    public <T extends Element> T parse(ANTLRInputStream is, Class<T> type) {
        try {
            return this.parse(is, type, e -> {});
        }
        catch (Error e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public <T extends Element> T parse(ANTLRInputStream is, Class<T> type, final Consumer<Exception> errorHandler) {
        PropositionalLogicLexer lexer = new PropositionalLogicLexer((CharStream)is);
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errorHandler.accept(new ParseException(msg, charPositionInLine));
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PropositionalLogicParser parser = new PropositionalLogicParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

            public void reportError(org.antlr.v4.runtime.Parser recognizer, RecognitionException e) {
                errorHandler.accept(e);
            }
        });
        ParserRuleContext tree = type.isAssignableFrom(DeclarationBlock.class) ? parser.block() : parser.formula();
        ASTBuilder builder = new ASTBuilder();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)builder, (ParseTree)tree);
        try {
            SymbolResolver resolver = new SymbolResolver(builder.values);
            walker.walk((ParseTreeListener)resolver, (ParseTree)tree);
            return (T)((Element)resolver.getValue((ParseTree)tree, type));
        }
        catch (SymbolResolver.SymbolMissingException e) {
            errorHandler.accept(e);
            return null;
        }
    }

    public URI saveXMI(Element object, String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        Resource r = resourceSet.createResource(URI.createFileURI((String)fileName));
        r.getContents().add((Object)object);
        r.save(Collections.emptyMap());
        return r.getURI();
    }

    public static class ErrorHandler
    extends BaseErrorListener {
        public void syntaxError(Recognizer<?, ?> rec, Object offendingSymbol, int line, int column, String msg, RecognitionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

