/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.graph;

import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableSet;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.utils.Pair;
import plug.utils.ui.graph.EdgeView;
import plug.utils.ui.graph.GraphView;
import plug.utils.ui.graph.GraphViewModel;

public class VertexView<T, E>
extends BorderPane {
    protected final GraphView<T, E> parent;
    protected final T data;
    protected final Region node;
    protected final FontIcon foldIcon;
    protected final FontIcon removeIcon;
    protected final BooleanProperty selected = new SimpleBooleanProperty(false);
    protected final BooleanProperty hideDetails = new SimpleBooleanProperty(false);
    protected final BooleanProperty colored = new SimpleBooleanProperty(true);
    protected final ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.WHITE);
    protected Border border = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(3.0))});
    protected Border selectedBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, new CornerRadii(5.0), new BorderWidths(3.0))});

    public VertexView(GraphView<T, E> parent, T data) {
        this.parent = parent;
        this.data = data;
        if (parent == null && data == null) {
            this.node = null;
            this.foldIcon = null;
            this.removeIcon = null;
            return;
        }
        GraphViewModel<T, E> model = parent.getModel();
        this.node = model.vertexNode(data);
        this.setPadding(new Insets(5.0));
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(5.0), new Insets(0.0))}));
        this.setBorder(this.border);
        BorderPane header = new BorderPane();
        Label id = new Label(model.vertexDescription(data));
        header.setLeft((Node)id);
        boolean sink = model.vertexIsSink(data);
        this.foldIcon = new FontIcon(sink ? "typ-cancel:20" : "typ-chevron-right:20");
        this.removeIcon = new FontIcon("typ-delete:20");
        HBox tools = new HBox(new Node[]{this.removeIcon, this.foldIcon});
        HBox.setMargin((Node)this.removeIcon, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        HBox.setMargin((Node)this.foldIcon, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        header.setRight((Node)tools);
        this.setTop((Node)header);
        this.removeIcon.setOnMouseClicked(e -> {
            if (e.getClickCount() == 1) {
                Pair pair = parent.reachableGraphicalElementsFrom(this);
                for (EdgeView edgeView : (Set)pair.b) {
                    model.getEdges().remove(edgeView.getData());
                }
                model.removeVertex(data);
            }
        });
        if (!sink) {
            this.foldIcon.setOnMouseClicked(e -> {
                if (e.getClickCount() == 1 && parent.nodeFoldingProperty().get()) {
                    ObservableSet<VertexView> foldedNodes = parent.getFoldedNodes();
                    if (foldedNodes.contains((Object)this)) {
                        foldedNodes.remove((Object)this);
                        this.foldIcon.setIconLiteral("typ-chevron-right:20");
                    } else {
                        foldedNodes.add((Object)this);
                        this.foldIcon.setIconLiteral("typ-chevron-left:20");
                    }
                }
            });
        }
        this.setMaxWidth(parent.getNodeMaxWidth());
        this.setMaxHeight(parent.getNodeMaxHeight());
        this.setOnMouseClicked(e -> parent.setSelectedVertex(this.getData()));
        this.selectedProperty().addListener((observable, oldValue, newValue) -> this.setBorder(newValue != false ? this.selectedBorder : this.border));
        if (this.node != null) {
            this.setCenter((Node)this.node);
            header.prefWidthProperty().bind((ObservableValue)this.node.prefWidthProperty());
            this.hideDetailsProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.setCenter(null);
                    header.prefWidthProperty().unbind();
                    header.prefWidthProperty().set(0.0);
                } else {
                    this.setCenter((Node)this.node);
                    header.prefWidthProperty().bind((ObservableValue)this.node.prefWidthProperty());
                }
            });
            this.node.setOnMouseClicked(e -> parent.setSelectedVertex(this.getData()));
        }
        this.widthProperty().addListener(e -> parent.refreshTreeLayout());
        this.heightProperty().addListener(e -> parent.refreshTreeLayout());
        this.colored.addListener((observable, oldValue, newValue) -> {
            Color newColor = newValue != false ? (Color)this.color.get() : Color.WHITE;
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)newColor, new CornerRadii(5.0), new Insets(0.0))}));
        });
        this.color.addListener((observable, oldValue, newValue) -> {
            Color newColor = newValue != null && this.colored.get() ? newValue : Color.WHITE;
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)newColor, new CornerRadii(5.0), new Insets(0.0))}));
        });
        this.color.set((Object)model.vertexColor(data));
    }

    public Region getNode() {
        return this.node;
    }

    public T getData() {
        return this.data;
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public BooleanProperty hideDetailsProperty() {
        return this.hideDetails;
    }

    public BooleanProperty coloredProperty() {
        return this.colored;
    }

    public ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public Color getColor() {
        return (Color)this.color.get();
    }

    public void setColor(Color color) {
        this.color.set((Object)color);
    }

    public String toString() {
        return String.format("V[%s]", this.data == null ? "null" : this.data.toString());
    }
}

